<?php

namespace EnumType;

/**
 * This class stands for RoutePointTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: route_point_type TPEG pti_table15.
 * @subpackage Enumerations
 */
class RoutePointTypeEnumeration
{
    /**
     * Constant for value 'pti15_0'
     * @return string 'pti15_0'
     */
    const VALUE_PTI_15_0 = 'pti15_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti15_1'
     * @return string 'pti15_1'
     */
    const VALUE_PTI_15_1 = 'pti15_1';
    /**
     * Constant for value 'startPoint'
     * @return string 'startPoint'
     */
    const VALUE_START_POINT = 'startPoint';
    /**
     * Constant for value 'pti15_2'
     * @return string 'pti15_2'
     */
    const VALUE_PTI_15_2 = 'pti15_2';
    /**
     * Constant for value 'destination'
     * @return string 'destination'
     */
    const VALUE_DESTINATION = 'destination';
    /**
     * Constant for value 'pti15_3'
     * @return string 'pti15_3'
     */
    const VALUE_PTI_15_3 = 'pti15_3';
    /**
     * Constant for value 'stop'
     * @return string 'stop'
     */
    const VALUE_STOP = 'stop';
    /**
     * Constant for value 'pti15_4'
     * @return string 'pti15_4'
     */
    const VALUE_PTI_15_4 = 'pti15_4';
    /**
     * Constant for value 'via'
     * @return string 'via'
     */
    const VALUE_VIA = 'via';
    /**
     * Constant for value 'pti15_5'
     * @return string 'pti15_5'
     */
    const VALUE_PTI_15_5 = 'pti15_5';
    /**
     * Constant for value 'notStopping'
     * @return string 'notStopping'
     */
    const VALUE_NOT_STOPPING = 'notStopping';
    /**
     * Constant for value 'pti15_6'
     * @return string 'pti15_6'
     */
    const VALUE_PTI_15_6 = 'pti15_6';
    /**
     * Constant for value 'temporaryStop'
     * @return string 'temporaryStop'
     */
    const VALUE_TEMPORARY_STOP = 'temporaryStop';
    /**
     * Constant for value 'pti15_7'
     * @return string 'pti15_7'
     */
    const VALUE_PTI_15_7 = 'pti15_7';
    /**
     * Constant for value 'temporarilyNotStopping'
     * @return string 'temporarilyNotStopping'
     */
    const VALUE_TEMPORARILY_NOT_STOPPING = 'temporarilyNotStopping';
    /**
     * Constant for value 'pti15_8'
     * @return string 'pti15_8'
     */
    const VALUE_PTI_15_8 = 'pti15_8';
    /**
     * Constant for value 'exceptionalStop'
     * @return string 'exceptionalStop'
     */
    const VALUE_EXCEPTIONAL_STOP = 'exceptionalStop';
    /**
     * Constant for value 'pti15_9'
     * @return string 'pti15_9'
     */
    const VALUE_PTI_15_9 = 'pti15_9';
    /**
     * Constant for value 'additionalStop'
     * @return string 'additionalStop'
     */
    const VALUE_ADDITIONAL_STOP = 'additionalStop';
    /**
     * Constant for value 'pti15_10'
     * @return string 'pti15_10'
     */
    const VALUE_PTI_15_10 = 'pti15_10';
    /**
     * Constant for value 'requestStop'
     * @return string 'requestStop'
     */
    const VALUE_REQUEST_STOP = 'requestStop';
    /**
     * Constant for value 'pti15_11'
     * @return string 'pti15_11'
     */
    const VALUE_PTI_15_11 = 'pti15_11';
    /**
     * Constant for value 'frontTrainDestination'
     * @return string 'frontTrainDestination'
     */
    const VALUE_FRONT_TRAIN_DESTINATION = 'frontTrainDestination';
    /**
     * Constant for value 'pti15_12'
     * @return string 'pti15_12'
     */
    const VALUE_PTI_15_12 = 'pti15_12';
    /**
     * Constant for value 'rearTrainDestination'
     * @return string 'rearTrainDestination'
     */
    const VALUE_REAR_TRAIN_DESTINATION = 'rearTrainDestination';
    /**
     * Constant for value 'pti15_13'
     * @return string 'pti15_13'
     */
    const VALUE_PTI_15_13 = 'pti15_13';
    /**
     * Constant for value 'throughServiceDestination'
     * @return string 'throughServiceDestination'
     */
    const VALUE_THROUGH_SERVICE_DESTINATION = 'throughServiceDestination';
    /**
     * Constant for value 'pti15_14'
     * @return string 'pti15_14'
     */
    const VALUE_PTI_15_14 = 'pti15_14';
    /**
     * Constant for value 'notVia'
     * @return string 'notVia'
     */
    const VALUE_NOT_VIA = 'notVia';
    /**
     * Constant for value 'pti15_15'
     * @return string 'pti15_15'
     */
    const VALUE_PTI_15_15 = 'pti15_15';
    /**
     * Constant for value 'alteredStartPoint'
     * @return string 'alteredStartPoint'
     */
    const VALUE_ALTERED_START_POINT = 'alteredStartPoint';
    /**
     * Constant for value 'pti15_16'
     * @return string 'pti15_16'
     */
    const VALUE_PTI_15_16 = 'pti15_16';
    /**
     * Constant for value 'alteredDestination'
     * @return string 'alteredDestination'
     */
    const VALUE_ALTERED_DESTINATION = 'alteredDestination';
    /**
     * Constant for value 'pti15_255'
     * @return string 'pti15_255'
     */
    const VALUE_PTI_15_255 = 'pti15_255';
    /**
     * Constant for value 'undefinedRoutePoint'
     * @return string 'undefinedRoutePoint'
     */
    const VALUE_UNDEFINED_ROUTE_POINT = 'undefinedRoutePoint';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_15_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_15_1
     * @uses self::VALUE_START_POINT
     * @uses self::VALUE_PTI_15_2
     * @uses self::VALUE_DESTINATION
     * @uses self::VALUE_PTI_15_3
     * @uses self::VALUE_STOP
     * @uses self::VALUE_PTI_15_4
     * @uses self::VALUE_VIA
     * @uses self::VALUE_PTI_15_5
     * @uses self::VALUE_NOT_STOPPING
     * @uses self::VALUE_PTI_15_6
     * @uses self::VALUE_TEMPORARY_STOP
     * @uses self::VALUE_PTI_15_7
     * @uses self::VALUE_TEMPORARILY_NOT_STOPPING
     * @uses self::VALUE_PTI_15_8
     * @uses self::VALUE_EXCEPTIONAL_STOP
     * @uses self::VALUE_PTI_15_9
     * @uses self::VALUE_ADDITIONAL_STOP
     * @uses self::VALUE_PTI_15_10
     * @uses self::VALUE_REQUEST_STOP
     * @uses self::VALUE_PTI_15_11
     * @uses self::VALUE_FRONT_TRAIN_DESTINATION
     * @uses self::VALUE_PTI_15_12
     * @uses self::VALUE_REAR_TRAIN_DESTINATION
     * @uses self::VALUE_PTI_15_13
     * @uses self::VALUE_THROUGH_SERVICE_DESTINATION
     * @uses self::VALUE_PTI_15_14
     * @uses self::VALUE_NOT_VIA
     * @uses self::VALUE_PTI_15_15
     * @uses self::VALUE_ALTERED_START_POINT
     * @uses self::VALUE_PTI_15_16
     * @uses self::VALUE_ALTERED_DESTINATION
     * @uses self::VALUE_PTI_15_255
     * @uses self::VALUE_UNDEFINED_ROUTE_POINT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_15_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_15_1,
            self::VALUE_START_POINT,
            self::VALUE_PTI_15_2,
            self::VALUE_DESTINATION,
            self::VALUE_PTI_15_3,
            self::VALUE_STOP,
            self::VALUE_PTI_15_4,
            self::VALUE_VIA,
            self::VALUE_PTI_15_5,
            self::VALUE_NOT_STOPPING,
            self::VALUE_PTI_15_6,
            self::VALUE_TEMPORARY_STOP,
            self::VALUE_PTI_15_7,
            self::VALUE_TEMPORARILY_NOT_STOPPING,
            self::VALUE_PTI_15_8,
            self::VALUE_EXCEPTIONAL_STOP,
            self::VALUE_PTI_15_9,
            self::VALUE_ADDITIONAL_STOP,
            self::VALUE_PTI_15_10,
            self::VALUE_REQUEST_STOP,
            self::VALUE_PTI_15_11,
            self::VALUE_FRONT_TRAIN_DESTINATION,
            self::VALUE_PTI_15_12,
            self::VALUE_REAR_TRAIN_DESTINATION,
            self::VALUE_PTI_15_13,
            self::VALUE_THROUGH_SERVICE_DESTINATION,
            self::VALUE_PTI_15_14,
            self::VALUE_NOT_VIA,
            self::VALUE_PTI_15_15,
            self::VALUE_ALTERED_START_POINT,
            self::VALUE_PTI_15_16,
            self::VALUE_ALTERED_DESTINATION,
            self::VALUE_PTI_15_255,
            self::VALUE_UNDEFINED_ROUTE_POINT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
