<?php

namespace EnumType;

/**
 * This class stands for RoadworksScaleEnum EnumType
 * @subpackage Enumerations
 */
class RoadworksScaleEnum
{
    /**
     * Constant for value 'major'
     * @return string 'major'
     */
    const VALUE_MAJOR = 'major';
    /**
     * Constant for value 'medium'
     * @return string 'medium'
     */
    const VALUE_MEDIUM = 'medium';
    /**
     * Constant for value 'minor'
     * @return string 'minor'
     */
    const VALUE_MINOR = 'minor';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MAJOR
     * @uses self::VALUE_MEDIUM
     * @uses self::VALUE_MINOR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MAJOR,
            self::VALUE_MEDIUM,
            self::VALUE_MINOR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
