<?php

namespace EnumType;

/**
 * This class stands for ResponseEnum EnumType
 * @subpackage Enumerations
 */
class ResponseEnum
{
    /**
     * Constant for value 'acknowledge'
     * @return string 'acknowledge'
     */
    const VALUE_ACKNOWLEDGE = 'acknowledge';
    /**
     * Constant for value 'catalogueRequestDenied'
     * @return string 'catalogueRequestDenied'
     */
    const VALUE_CATALOGUE_REQUEST_DENIED = 'catalogueRequestDenied';
    /**
     * Constant for value 'filterRequestDenied'
     * @return string 'filterRequestDenied'
     */
    const VALUE_FILTER_REQUEST_DENIED = 'filterRequestDenied';
    /**
     * Constant for value 'requestDenied'
     * @return string 'requestDenied'
     */
    const VALUE_REQUEST_DENIED = 'requestDenied';
    /**
     * Constant for value 'subscriptionRequestDenied'
     * @return string 'subscriptionRequestDenied'
     */
    const VALUE_SUBSCRIPTION_REQUEST_DENIED = 'subscriptionRequestDenied';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACKNOWLEDGE
     * @uses self::VALUE_CATALOGUE_REQUEST_DENIED
     * @uses self::VALUE_FILTER_REQUEST_DENIED
     * @uses self::VALUE_REQUEST_DENIED
     * @uses self::VALUE_SUBSCRIPTION_REQUEST_DENIED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACKNOWLEDGE,
            self::VALUE_CATALOGUE_REQUEST_DENIED,
            self::VALUE_FILTER_REQUEST_DENIED,
            self::VALUE_REQUEST_DENIED,
            self::VALUE_SUBSCRIPTION_REQUEST_DENIED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
