<?php

namespace EnumType;

/**
 * This class stands for RequestTypeEnum EnumType
 * @subpackage Enumerations
 */
class RequestTypeEnum
{
    /**
     * Constant for value 'catalogue'
     * @return string 'catalogue'
     */
    const VALUE_CATALOGUE = 'catalogue';
    /**
     * Constant for value 'filter'
     * @return string 'filter'
     */
    const VALUE_FILTER = 'filter';
    /**
     * Constant for value 'requestData'
     * @return string 'requestData'
     */
    const VALUE_REQUEST_DATA = 'requestData';
    /**
     * Constant for value 'requestHistoricalData'
     * @return string 'requestHistoricalData'
     */
    const VALUE_REQUEST_HISTORICAL_DATA = 'requestHistoricalData';
    /**
     * Constant for value 'subscription'
     * @return string 'subscription'
     */
    const VALUE_SUBSCRIPTION = 'subscription';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CATALOGUE
     * @uses self::VALUE_FILTER
     * @uses self::VALUE_REQUEST_DATA
     * @uses self::VALUE_REQUEST_HISTORICAL_DATA
     * @uses self::VALUE_SUBSCRIPTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CATALOGUE,
            self::VALUE_FILTER,
            self::VALUE_REQUEST_DATA,
            self::VALUE_REQUEST_HISTORICAL_DATA,
            self::VALUE_SUBSCRIPTION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
