<?php

namespace EnumType;

/**
 * This class stands for RelativeTrafficFlowEnum EnumType
 * @subpackage Enumerations
 */
class RelativeTrafficFlowEnum
{
    /**
     * Constant for value 'trafficVeryMuchHeavierThanNormal'
     * @return string 'trafficVeryMuchHeavierThanNormal'
     */
    const VALUE_TRAFFIC_VERY_MUCH_HEAVIER_THAN_NORMAL = 'trafficVeryMuchHeavierThanNormal';
    /**
     * Constant for value 'trafficHeavierThanNormal'
     * @return string 'trafficHeavierThanNormal'
     */
    const VALUE_TRAFFIC_HEAVIER_THAN_NORMAL = 'trafficHeavierThanNormal';
    /**
     * Constant for value 'trafficFlowNormal'
     * @return string 'trafficFlowNormal'
     */
    const VALUE_TRAFFIC_FLOW_NORMAL = 'trafficFlowNormal';
    /**
     * Constant for value 'trafficLighterThanNormal'
     * @return string 'trafficLighterThanNormal'
     */
    const VALUE_TRAFFIC_LIGHTER_THAN_NORMAL = 'trafficLighterThanNormal';
    /**
     * Constant for value 'trafficVeryMuchLighterThanNormal'
     * @return string 'trafficVeryMuchLighterThanNormal'
     */
    const VALUE_TRAFFIC_VERY_MUCH_LIGHTER_THAN_NORMAL = 'trafficVeryMuchLighterThanNormal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRAFFIC_VERY_MUCH_HEAVIER_THAN_NORMAL
     * @uses self::VALUE_TRAFFIC_HEAVIER_THAN_NORMAL
     * @uses self::VALUE_TRAFFIC_FLOW_NORMAL
     * @uses self::VALUE_TRAFFIC_LIGHTER_THAN_NORMAL
     * @uses self::VALUE_TRAFFIC_VERY_MUCH_LIGHTER_THAN_NORMAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRAFFIC_VERY_MUCH_HEAVIER_THAN_NORMAL,
            self::VALUE_TRAFFIC_HEAVIER_THAN_NORMAL,
            self::VALUE_TRAFFIC_FLOW_NORMAL,
            self::VALUE_TRAFFIC_LIGHTER_THAN_NORMAL,
            self::VALUE_TRAFFIC_VERY_MUCH_LIGHTER_THAN_NORMAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
