<?php

namespace EnumType;

/**
 * This class stands for RefreshmentFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Refreshment Facility: TPEG pti_table 23.
 * @subpackage Enumerations
 */
class RefreshmentFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti23_1'
     * @return string 'pti23_1'
     */
    const VALUE_PTI_23_1 = 'pti23_1';
    /**
     * Constant for value 'restaurantService'
     * @return string 'restaurantService'
     */
    const VALUE_RESTAURANT_SERVICE = 'restaurantService';
    /**
     * Constant for value 'pti23_2'
     * @return string 'pti23_2'
     */
    const VALUE_PTI_23_2 = 'pti23_2';
    /**
     * Constant for value 'snacksService'
     * @return string 'snacksService'
     */
    const VALUE_SNACKS_SERVICE = 'snacksService';
    /**
     * Constant for value 'pti23'
     * @return string 'pti23'
     */
    const VALUE_PTI_23 = 'pti23';
    /**
     * Constant for value 'trolley'
     * @return string 'trolley'
     */
    const VALUE_TROLLEY = 'trolley';
    /**
     * Constant for value 'pti23_18'
     * @return string 'pti23_18'
     */
    const VALUE_PTI_23_18 = 'pti23_18';
    /**
     * Constant for value 'bar'
     * @return string 'bar'
     */
    const VALUE_BAR = 'bar';
    /**
     * Constant for value 'pti23_19'
     * @return string 'pti23_19'
     */
    const VALUE_PTI_23_19 = 'pti23_19';
    /**
     * Constant for value 'foodNotAvailable'
     * @return string 'foodNotAvailable'
     */
    const VALUE_FOOD_NOT_AVAILABLE = 'foodNotAvailable';
    /**
     * Constant for value 'pti23_20'
     * @return string 'pti23_20'
     */
    const VALUE_PTI_23_20 = 'pti23_20';
    /**
     * Constant for value 'beveragesNotAvailable'
     * @return string 'beveragesNotAvailable'
     */
    const VALUE_BEVERAGES_NOT_AVAILABLE = 'beveragesNotAvailable';
    /**
     * Constant for value 'pti23_26'
     * @return string 'pti23_26'
     */
    const VALUE_PTI_23_26 = 'pti23_26';
    /**
     * Constant for value 'bistro'
     * @return string 'bistro'
     */
    const VALUE_BISTRO = 'bistro';
    /**
     * Constant for value 'foodVendingMachine'
     * @return string 'foodVendingMachine'
     */
    const VALUE_FOOD_VENDING_MACHINE = 'foodVendingMachine';
    /**
     * Constant for value 'beverageVendingMachine'
     * @return string 'beverageVendingMachine'
     */
    const VALUE_BEVERAGE_VENDING_MACHINE = 'beverageVendingMachine';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_23_1
     * @uses self::VALUE_RESTAURANT_SERVICE
     * @uses self::VALUE_PTI_23_2
     * @uses self::VALUE_SNACKS_SERVICE
     * @uses self::VALUE_PTI_23
     * @uses self::VALUE_TROLLEY
     * @uses self::VALUE_PTI_23_18
     * @uses self::VALUE_BAR
     * @uses self::VALUE_PTI_23_19
     * @uses self::VALUE_FOOD_NOT_AVAILABLE
     * @uses self::VALUE_PTI_23_20
     * @uses self::VALUE_BEVERAGES_NOT_AVAILABLE
     * @uses self::VALUE_PTI_23_26
     * @uses self::VALUE_BISTRO
     * @uses self::VALUE_FOOD_VENDING_MACHINE
     * @uses self::VALUE_BEVERAGE_VENDING_MACHINE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_23_1,
            self::VALUE_RESTAURANT_SERVICE,
            self::VALUE_PTI_23_2,
            self::VALUE_SNACKS_SERVICE,
            self::VALUE_PTI_23,
            self::VALUE_TROLLEY,
            self::VALUE_PTI_23_18,
            self::VALUE_BAR,
            self::VALUE_PTI_23_19,
            self::VALUE_FOOD_NOT_AVAILABLE,
            self::VALUE_PTI_23_20,
            self::VALUE_BEVERAGES_NOT_AVAILABLE,
            self::VALUE_PTI_23_26,
            self::VALUE_BISTRO,
            self::VALUE_FOOD_VENDING_MACHINE,
            self::VALUE_BEVERAGE_VENDING_MACHINE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
