<?php

namespace EnumType;

/**
 * This class stands for QuayTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of QUAY Types.
 * @subpackage Enumerations
 */
class QuayTypeEnumeration
{
    /**
     * Constant for value 'airlineGate'
     * @return string 'airlineGate'
     */
    const VALUE_AIRLINE_GATE = 'airlineGate';
    /**
     * Constant for value 'railPlatform'
     * @return string 'railPlatform'
     */
    const VALUE_RAIL_PLATFORM = 'railPlatform';
    /**
     * Constant for value 'metroPlatform'
     * @return string 'metroPlatform'
     */
    const VALUE_METRO_PLATFORM = 'metroPlatform';
    /**
     * Constant for value 'coachStop'
     * @return string 'coachStop'
     */
    const VALUE_COACH_STOP = 'coachStop';
    /**
     * Constant for value 'busStop'
     * @return string 'busStop'
     */
    const VALUE_BUS_STOP = 'busStop';
    /**
     * Constant for value 'tramStop'
     * @return string 'tramStop'
     */
    const VALUE_TRAM_STOP = 'tramStop';
    /**
     * Constant for value 'boatQuay'
     * @return string 'boatQuay'
     */
    const VALUE_BOAT_QUAY = 'boatQuay';
    /**
     * Constant for value 'ferryLanding'
     * @return string 'ferryLanding'
     */
    const VALUE_FERRY_LANDING = 'ferryLanding';
    /**
     * Constant for value 'telecabinePlatfrom'
     * @return string 'telecabinePlatfrom'
     */
    const VALUE_TELECABINE_PLATFROM = 'telecabinePlatfrom';
    /**
     * Constant for value 'taxiStand'
     * @return string 'taxiStand'
     */
    const VALUE_TAXI_STAND = 'taxiStand';
    /**
     * Constant for value 'setDownPlace'
     * @return string 'setDownPlace'
     */
    const VALUE_SET_DOWN_PLACE = 'setDownPlace';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIRLINE_GATE
     * @uses self::VALUE_RAIL_PLATFORM
     * @uses self::VALUE_METRO_PLATFORM
     * @uses self::VALUE_COACH_STOP
     * @uses self::VALUE_BUS_STOP
     * @uses self::VALUE_TRAM_STOP
     * @uses self::VALUE_BOAT_QUAY
     * @uses self::VALUE_FERRY_LANDING
     * @uses self::VALUE_TELECABINE_PLATFROM
     * @uses self::VALUE_TAXI_STAND
     * @uses self::VALUE_SET_DOWN_PLACE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIRLINE_GATE,
            self::VALUE_RAIL_PLATFORM,
            self::VALUE_METRO_PLATFORM,
            self::VALUE_COACH_STOP,
            self::VALUE_BUS_STOP,
            self::VALUE_TRAM_STOP,
            self::VALUE_BOAT_QUAY,
            self::VALUE_FERRY_LANDING,
            self::VALUE_TELECABINE_PLATFROM,
            self::VALUE_TAXI_STAND,
            self::VALUE_SET_DOWN_PLACE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
