<?php

namespace EnumType;

/**
 * This class stands for ProgressRateEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Classification of the rate of progress of VEHICLE according a fixed list of values.
 * @subpackage Enumerations
 */
class ProgressRateEnumeration
{
    /**
     * Constant for value 'noProgress'
     * @return string 'noProgress'
     */
    const VALUE_NO_PROGRESS = 'noProgress';
    /**
     * Constant for value 'slowProgress'
     * @return string 'slowProgress'
     */
    const VALUE_SLOW_PROGRESS = 'slowProgress';
    /**
     * Constant for value 'normalProgress'
     * @return string 'normalProgress'
     */
    const VALUE_NORMAL_PROGRESS = 'normalProgress';
    /**
     * Constant for value 'fastProgress'
     * @return string 'fastProgress'
     */
    const VALUE_FAST_PROGRESS = 'fastProgress';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_PROGRESS
     * @uses self::VALUE_SLOW_PROGRESS
     * @uses self::VALUE_NORMAL_PROGRESS
     * @uses self::VALUE_FAST_PROGRESS
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_PROGRESS,
            self::VALUE_SLOW_PROGRESS,
            self::VALUE_NORMAL_PROGRESS,
            self::VALUE_FAST_PROGRESS,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
