<?php

namespace EnumType;

/**
 * This class stands for PredictorsEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed values for predictors.
 * @subpackage Enumerations
 */
class PredictorsEnumeration
{
    /**
     * Constant for value 'avmsOnly'
     * @return string 'avmsOnly'
     */
    const VALUE_AVMS_ONLY = 'avmsOnly';
    /**
     * Constant for value 'anyone'
     * @return string 'anyone'
     */
    const VALUE_ANYONE = 'anyone';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AVMS_ONLY
     * @uses self::VALUE_ANYONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVMS_ONLY,
            self::VALUE_ANYONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
