<?php

namespace EnumType;

/**
 * This class stands for PredictabilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Predictability Status.
 * @subpackage Enumerations
 */
class PredictabilityEnumeration
{
    /**
     * Constant for value 'planned'
     * @return string 'planned'
     */
    const VALUE_PLANNED = 'planned';
    /**
     * Constant for value 'unplanned'
     * @return string 'unplanned'
     */
    const VALUE_UNPLANNED = 'unplanned';
    /**
     * Constant for value 'all'
     * @return string 'all'
     */
    const VALUE_ALL = 'all';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PLANNED
     * @uses self::VALUE_UNPLANNED
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PLANNED,
            self::VALUE_UNPLANNED,
            self::VALUE_ALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
