<?php

namespace EnumType;

/**
 * This class stands for PrecipitationTypeEnum EnumType
 * @subpackage Enumerations
 */
class PrecipitationTypeEnum
{
    /**
     * Constant for value 'drizzle'
     * @return string 'drizzle'
     */
    const VALUE_DRIZZLE = 'drizzle';
    /**
     * Constant for value 'freezingRain'
     * @return string 'freezingRain'
     */
    const VALUE_FREEZING_RAIN = 'freezingRain';
    /**
     * Constant for value 'hail'
     * @return string 'hail'
     */
    const VALUE_HAIL = 'hail';
    /**
     * Constant for value 'rain'
     * @return string 'rain'
     */
    const VALUE_RAIN = 'rain';
    /**
     * Constant for value 'sleet'
     * @return string 'sleet'
     */
    const VALUE_SLEET = 'sleet';
    /**
     * Constant for value 'snow'
     * @return string 'snow'
     */
    const VALUE_SNOW = 'snow';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DRIZZLE
     * @uses self::VALUE_FREEZING_RAIN
     * @uses self::VALUE_HAIL
     * @uses self::VALUE_RAIN
     * @uses self::VALUE_SLEET
     * @uses self::VALUE_SNOW
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DRIZZLE,
            self::VALUE_FREEZING_RAIN,
            self::VALUE_HAIL,
            self::VALUE_RAIN,
            self::VALUE_SLEET,
            self::VALUE_SNOW,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
