<?php

namespace EnumType;

/**
 * This class stands for PoorEnvironmentTypeEnum EnumType
 * @subpackage Enumerations
 */
class PoorEnvironmentTypeEnum
{
    /**
     * Constant for value 'badWeather'
     * @return string 'badWeather'
     */
    const VALUE_BAD_WEATHER = 'badWeather';
    /**
     * Constant for value 'blizzard'
     * @return string 'blizzard'
     */
    const VALUE_BLIZZARD = 'blizzard';
    /**
     * Constant for value 'blowingDust'
     * @return string 'blowingDust'
     */
    const VALUE_BLOWING_DUST = 'blowingDust';
    /**
     * Constant for value 'blowingSnow'
     * @return string 'blowingSnow'
     */
    const VALUE_BLOWING_SNOW = 'blowingSnow';
    /**
     * Constant for value 'crosswinds'
     * @return string 'crosswinds'
     */
    const VALUE_CROSSWINDS = 'crosswinds';
    /**
     * Constant for value 'damagingHail'
     * @return string 'damagingHail'
     */
    const VALUE_DAMAGING_HAIL = 'damagingHail';
    /**
     * Constant for value 'denseFog'
     * @return string 'denseFog'
     */
    const VALUE_DENSE_FOG = 'denseFog';
    /**
     * Constant for value 'eclipse'
     * @return string 'eclipse'
     */
    const VALUE_ECLIPSE = 'eclipse';
    /**
     * Constant for value 'extremeCold'
     * @return string 'extremeCold'
     */
    const VALUE_EXTREME_COLD = 'extremeCold';
    /**
     * Constant for value 'extremeHeat'
     * @return string 'extremeHeat'
     */
    const VALUE_EXTREME_HEAT = 'extremeHeat';
    /**
     * Constant for value 'fog'
     * @return string 'fog'
     */
    const VALUE_FOG = 'fog';
    /**
     * Constant for value 'freezingFog'
     * @return string 'freezingFog'
     */
    const VALUE_FREEZING_FOG = 'freezingFog';
    /**
     * Constant for value 'frost'
     * @return string 'frost'
     */
    const VALUE_FROST = 'frost';
    /**
     * Constant for value 'gales'
     * @return string 'gales'
     */
    const VALUE_GALES = 'gales';
    /**
     * Constant for value 'gustyWinds'
     * @return string 'gustyWinds'
     */
    const VALUE_GUSTY_WINDS = 'gustyWinds';
    /**
     * Constant for value 'hail'
     * @return string 'hail'
     */
    const VALUE_HAIL = 'hail';
    /**
     * Constant for value 'heavyFrost'
     * @return string 'heavyFrost'
     */
    const VALUE_HEAVY_FROST = 'heavyFrost';
    /**
     * Constant for value 'heavyRain'
     * @return string 'heavyRain'
     */
    const VALUE_HEAVY_RAIN = 'heavyRain';
    /**
     * Constant for value 'heavySnowfall'
     * @return string 'heavySnowfall'
     */
    const VALUE_HEAVY_SNOWFALL = 'heavySnowfall';
    /**
     * Constant for value 'hurricaneForceWinds'
     * @return string 'hurricaneForceWinds'
     */
    const VALUE_HURRICANE_FORCE_WINDS = 'hurricaneForceWinds';
    /**
     * Constant for value 'lowSunGlare'
     * @return string 'lowSunGlare'
     */
    const VALUE_LOW_SUN_GLARE = 'lowSunGlare';
    /**
     * Constant for value 'moderateFog'
     * @return string 'moderateFog'
     */
    const VALUE_MODERATE_FOG = 'moderateFog';
    /**
     * Constant for value 'ozonePollution'
     * @return string 'ozonePollution'
     */
    const VALUE_OZONE_POLLUTION = 'ozonePollution';
    /**
     * Constant for value 'pollution'
     * @return string 'pollution'
     */
    const VALUE_POLLUTION = 'pollution';
    /**
     * Constant for value 'patchyFog'
     * @return string 'patchyFog'
     */
    const VALUE_PATCHY_FOG = 'patchyFog';
    /**
     * Constant for value 'precipitationInTheArea'
     * @return string 'precipitationInTheArea'
     */
    const VALUE_PRECIPITATION_IN_THE_AREA = 'precipitationInTheArea';
    /**
     * Constant for value 'rain'
     * @return string 'rain'
     */
    const VALUE_RAIN = 'rain';
    /**
     * Constant for value 'rainChangingToSnow'
     * @return string 'rainChangingToSnow'
     */
    const VALUE_RAIN_CHANGING_TO_SNOW = 'rainChangingToSnow';
    /**
     * Constant for value 'sandStorms'
     * @return string 'sandStorms'
     */
    const VALUE_SAND_STORMS = 'sandStorms';
    /**
     * Constant for value 'severeExhaustPollution'
     * @return string 'severeExhaustPollution'
     */
    const VALUE_SEVERE_EXHAUST_POLLUTION = 'severeExhaustPollution';
    /**
     * Constant for value 'severeSmog'
     * @return string 'severeSmog'
     */
    const VALUE_SEVERE_SMOG = 'severeSmog';
    /**
     * Constant for value 'showers'
     * @return string 'showers'
     */
    const VALUE_SHOWERS = 'showers';
    /**
     * Constant for value 'sleet'
     * @return string 'sleet'
     */
    const VALUE_SLEET = 'sleet';
    /**
     * Constant for value 'smogAlert'
     * @return string 'smogAlert'
     */
    const VALUE_SMOG_ALERT = 'smogAlert';
    /**
     * Constant for value 'smokeHazard'
     * @return string 'smokeHazard'
     */
    const VALUE_SMOKE_HAZARD = 'smokeHazard';
    /**
     * Constant for value 'snowChangingToRain'
     * @return string 'snowChangingToRain'
     */
    const VALUE_SNOW_CHANGING_TO_RAIN = 'snowChangingToRain';
    /**
     * Constant for value 'snowfall'
     * @return string 'snowfall'
     */
    const VALUE_SNOWFALL = 'snowfall';
    /**
     * Constant for value 'sprayHazard'
     * @return string 'sprayHazard'
     */
    const VALUE_SPRAY_HAZARD = 'sprayHazard';
    /**
     * Constant for value 'stormForceWinds'
     * @return string 'stormForceWinds'
     */
    const VALUE_STORM_FORCE_WINDS = 'stormForceWinds';
    /**
     * Constant for value 'strongGustsOfWind'
     * @return string 'strongGustsOfWind'
     */
    const VALUE_STRONG_GUSTS_OF_WIND = 'strongGustsOfWind';
    /**
     * Constant for value 'strongWinds'
     * @return string 'strongWinds'
     */
    const VALUE_STRONG_WINDS = 'strongWinds';
    /**
     * Constant for value 'swarmsOfInsects'
     * @return string 'swarmsOfInsects'
     */
    const VALUE_SWARMS_OF_INSECTS = 'swarmsOfInsects';
    /**
     * Constant for value 'temperatureFalling'
     * @return string 'temperatureFalling'
     */
    const VALUE_TEMPERATURE_FALLING = 'temperatureFalling';
    /**
     * Constant for value 'thunderstorms'
     * @return string 'thunderstorms'
     */
    const VALUE_THUNDERSTORMS = 'thunderstorms';
    /**
     * Constant for value 'tornadoes'
     * @return string 'tornadoes'
     */
    const VALUE_TORNADOES = 'tornadoes';
    /**
     * Constant for value 'veryStrongGustsOfWind'
     * @return string 'veryStrongGustsOfWind'
     */
    const VALUE_VERY_STRONG_GUSTS_OF_WIND = 'veryStrongGustsOfWind';
    /**
     * Constant for value 'visibilityReduced'
     * @return string 'visibilityReduced'
     */
    const VALUE_VISIBILITY_REDUCED = 'visibilityReduced';
    /**
     * Constant for value 'whiteOut'
     * @return string 'whiteOut'
     */
    const VALUE_WHITE_OUT = 'whiteOut';
    /**
     * Constant for value 'winterStorm'
     * @return string 'winterStorm'
     */
    const VALUE_WINTER_STORM = 'winterStorm';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BAD_WEATHER
     * @uses self::VALUE_BLIZZARD
     * @uses self::VALUE_BLOWING_DUST
     * @uses self::VALUE_BLOWING_SNOW
     * @uses self::VALUE_CROSSWINDS
     * @uses self::VALUE_DAMAGING_HAIL
     * @uses self::VALUE_DENSE_FOG
     * @uses self::VALUE_ECLIPSE
     * @uses self::VALUE_EXTREME_COLD
     * @uses self::VALUE_EXTREME_HEAT
     * @uses self::VALUE_FOG
     * @uses self::VALUE_FREEZING_FOG
     * @uses self::VALUE_FROST
     * @uses self::VALUE_GALES
     * @uses self::VALUE_GUSTY_WINDS
     * @uses self::VALUE_HAIL
     * @uses self::VALUE_HEAVY_FROST
     * @uses self::VALUE_HEAVY_RAIN
     * @uses self::VALUE_HEAVY_SNOWFALL
     * @uses self::VALUE_HURRICANE_FORCE_WINDS
     * @uses self::VALUE_LOW_SUN_GLARE
     * @uses self::VALUE_MODERATE_FOG
     * @uses self::VALUE_OZONE_POLLUTION
     * @uses self::VALUE_POLLUTION
     * @uses self::VALUE_PATCHY_FOG
     * @uses self::VALUE_PRECIPITATION_IN_THE_AREA
     * @uses self::VALUE_RAIN
     * @uses self::VALUE_RAIN_CHANGING_TO_SNOW
     * @uses self::VALUE_SAND_STORMS
     * @uses self::VALUE_SEVERE_EXHAUST_POLLUTION
     * @uses self::VALUE_SEVERE_SMOG
     * @uses self::VALUE_SHOWERS
     * @uses self::VALUE_SLEET
     * @uses self::VALUE_SMOG_ALERT
     * @uses self::VALUE_SMOKE_HAZARD
     * @uses self::VALUE_SNOW_CHANGING_TO_RAIN
     * @uses self::VALUE_SNOWFALL
     * @uses self::VALUE_SPRAY_HAZARD
     * @uses self::VALUE_STORM_FORCE_WINDS
     * @uses self::VALUE_STRONG_GUSTS_OF_WIND
     * @uses self::VALUE_STRONG_WINDS
     * @uses self::VALUE_SWARMS_OF_INSECTS
     * @uses self::VALUE_TEMPERATURE_FALLING
     * @uses self::VALUE_THUNDERSTORMS
     * @uses self::VALUE_TORNADOES
     * @uses self::VALUE_VERY_STRONG_GUSTS_OF_WIND
     * @uses self::VALUE_VISIBILITY_REDUCED
     * @uses self::VALUE_WHITE_OUT
     * @uses self::VALUE_WINTER_STORM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BAD_WEATHER,
            self::VALUE_BLIZZARD,
            self::VALUE_BLOWING_DUST,
            self::VALUE_BLOWING_SNOW,
            self::VALUE_CROSSWINDS,
            self::VALUE_DAMAGING_HAIL,
            self::VALUE_DENSE_FOG,
            self::VALUE_ECLIPSE,
            self::VALUE_EXTREME_COLD,
            self::VALUE_EXTREME_HEAT,
            self::VALUE_FOG,
            self::VALUE_FREEZING_FOG,
            self::VALUE_FROST,
            self::VALUE_GALES,
            self::VALUE_GUSTY_WINDS,
            self::VALUE_HAIL,
            self::VALUE_HEAVY_FROST,
            self::VALUE_HEAVY_RAIN,
            self::VALUE_HEAVY_SNOWFALL,
            self::VALUE_HURRICANE_FORCE_WINDS,
            self::VALUE_LOW_SUN_GLARE,
            self::VALUE_MODERATE_FOG,
            self::VALUE_OZONE_POLLUTION,
            self::VALUE_POLLUTION,
            self::VALUE_PATCHY_FOG,
            self::VALUE_PRECIPITATION_IN_THE_AREA,
            self::VALUE_RAIN,
            self::VALUE_RAIN_CHANGING_TO_SNOW,
            self::VALUE_SAND_STORMS,
            self::VALUE_SEVERE_EXHAUST_POLLUTION,
            self::VALUE_SEVERE_SMOG,
            self::VALUE_SHOWERS,
            self::VALUE_SLEET,
            self::VALUE_SMOG_ALERT,
            self::VALUE_SMOKE_HAZARD,
            self::VALUE_SNOW_CHANGING_TO_RAIN,
            self::VALUE_SNOWFALL,
            self::VALUE_SPRAY_HAZARD,
            self::VALUE_STORM_FORCE_WINDS,
            self::VALUE_STRONG_GUSTS_OF_WIND,
            self::VALUE_STRONG_WINDS,
            self::VALUE_SWARMS_OF_INSECTS,
            self::VALUE_TEMPERATURE_FALLING,
            self::VALUE_THUNDERSTORMS,
            self::VALUE_TORNADOES,
            self::VALUE_VERY_STRONG_GUSTS_OF_WIND,
            self::VALUE_VISIBILITY_REDUCED,
            self::VALUE_WHITE_OUT,
            self::VALUE_WINTER_STORM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
