<?php

namespace EnumType;

/**
 * This class stands for PersonCategoryEnum EnumType
 * @subpackage Enumerations
 */
class PersonCategoryEnum
{
    /**
     * Constant for value 'adult'
     * @return string 'adult'
     */
    const VALUE_ADULT = 'adult';
    /**
     * Constant for value 'child'
     * @return string 'child'
     */
    const VALUE_CHILD = 'child';
    /**
     * Constant for value 'emergencyServicesPerson'
     * @return string 'emergencyServicesPerson'
     */
    const VALUE_EMERGENCY_SERVICES_PERSON = 'emergencyServicesPerson';
    /**
     * Constant for value 'fireman'
     * @return string 'fireman'
     */
    const VALUE_FIREMAN = 'fireman';
    /**
     * Constant for value 'infant'
     * @return string 'infant'
     */
    const VALUE_INFANT = 'infant';
    /**
     * Constant for value 'medicalStaff'
     * @return string 'medicalStaff'
     */
    const VALUE_MEDICAL_STAFF = 'medicalStaff';
    /**
     * Constant for value 'memberOfThePublic'
     * @return string 'memberOfThePublic'
     */
    const VALUE_MEMBER_OF_THE_PUBLIC = 'memberOfThePublic';
    /**
     * Constant for value 'policeman'
     * @return string 'policeman'
     */
    const VALUE_POLICEMAN = 'policeman';
    /**
     * Constant for value 'politician'
     * @return string 'politician'
     */
    const VALUE_POLITICIAN = 'politician';
    /**
     * Constant for value 'publicTransportPassenger'
     * @return string 'publicTransportPassenger'
     */
    const VALUE_PUBLIC_TRANSPORT_PASSENGER = 'publicTransportPassenger';
    /**
     * Constant for value 'sickPerson'
     * @return string 'sickPerson'
     */
    const VALUE_SICK_PERSON = 'sickPerson';
    /**
     * Constant for value 'trafficOfficer'
     * @return string 'trafficOfficer'
     */
    const VALUE_TRAFFIC_OFFICER = 'trafficOfficer';
    /**
     * Constant for value 'trafficWarden'
     * @return string 'trafficWarden'
     */
    const VALUE_TRAFFIC_WARDEN = 'trafficWarden';
    /**
     * Constant for value 'veryImportantPerson'
     * @return string 'veryImportantPerson'
     */
    const VALUE_VERY_IMPORTANT_PERSON = 'veryImportantPerson';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADULT
     * @uses self::VALUE_CHILD
     * @uses self::VALUE_EMERGENCY_SERVICES_PERSON
     * @uses self::VALUE_FIREMAN
     * @uses self::VALUE_INFANT
     * @uses self::VALUE_MEDICAL_STAFF
     * @uses self::VALUE_MEMBER_OF_THE_PUBLIC
     * @uses self::VALUE_POLICEMAN
     * @uses self::VALUE_POLITICIAN
     * @uses self::VALUE_PUBLIC_TRANSPORT_PASSENGER
     * @uses self::VALUE_SICK_PERSON
     * @uses self::VALUE_TRAFFIC_OFFICER
     * @uses self::VALUE_TRAFFIC_WARDEN
     * @uses self::VALUE_VERY_IMPORTANT_PERSON
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADULT,
            self::VALUE_CHILD,
            self::VALUE_EMERGENCY_SERVICES_PERSON,
            self::VALUE_FIREMAN,
            self::VALUE_INFANT,
            self::VALUE_MEDICAL_STAFF,
            self::VALUE_MEMBER_OF_THE_PUBLIC,
            self::VALUE_POLICEMAN,
            self::VALUE_POLITICIAN,
            self::VALUE_PUBLIC_TRANSPORT_PASSENGER,
            self::VALUE_SICK_PERSON,
            self::VALUE_TRAFFIC_OFFICER,
            self::VALUE_TRAFFIC_WARDEN,
            self::VALUE_VERY_IMPORTANT_PERSON,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
