<?php

namespace EnumType;

/**
 * This class stands for ParkingFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Access Facility.
 * @subpackage Enumerations
 */
class ParkingFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'carPark'
     * @return string 'carPark'
     */
    const VALUE_CAR_PARK = 'carPark';
    /**
     * Constant for value 'parkAndRidePark'
     * @return string 'parkAndRidePark'
     */
    const VALUE_PARK_AND_RIDE_PARK = 'parkAndRidePark';
    /**
     * Constant for value 'motorcyclePark'
     * @return string 'motorcyclePark'
     */
    const VALUE_MOTORCYCLE_PARK = 'motorcyclePark';
    /**
     * Constant for value 'cyclePark'
     * @return string 'cyclePark'
     */
    const VALUE_CYCLE_PARK = 'cyclePark';
    /**
     * Constant for value 'rentalCarPark'
     * @return string 'rentalCarPark'
     */
    const VALUE_RENTAL_CAR_PARK = 'rentalCarPark';
    /**
     * Constant for value 'coachPark'
     * @return string 'coachPark'
     */
    const VALUE_COACH_PARK = 'coachPark';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_CAR_PARK
     * @uses self::VALUE_PARK_AND_RIDE_PARK
     * @uses self::VALUE_MOTORCYCLE_PARK
     * @uses self::VALUE_CYCLE_PARK
     * @uses self::VALUE_RENTAL_CAR_PARK
     * @uses self::VALUE_COACH_PARK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_CAR_PARK,
            self::VALUE_PARK_AND_RIDE_PARK,
            self::VALUE_MOTORCYCLE_PARK,
            self::VALUE_CYCLE_PARK,
            self::VALUE_RENTAL_CAR_PARK,
            self::VALUE_COACH_PARK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
