<?php

namespace EnumType;

/**
 * This class stands for OperatingModeEnum EnumType
 * @subpackage Enumerations
 */
class OperatingModeEnum
{
    /**
     * Constant for value 'operatingMode0'
     * @return string 'operatingMode0'
     */
    const VALUE_OPERATING_MODE_0 = 'operatingMode0';
    /**
     * Constant for value 'operatingMode1'
     * @return string 'operatingMode1'
     */
    const VALUE_OPERATING_MODE_1 = 'operatingMode1';
    /**
     * Constant for value 'operatingMode2'
     * @return string 'operatingMode2'
     */
    const VALUE_OPERATING_MODE_2 = 'operatingMode2';
    /**
     * Constant for value 'operatingMode3'
     * @return string 'operatingMode3'
     */
    const VALUE_OPERATING_MODE_3 = 'operatingMode3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OPERATING_MODE_0
     * @uses self::VALUE_OPERATING_MODE_1
     * @uses self::VALUE_OPERATING_MODE_2
     * @uses self::VALUE_OPERATING_MODE_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OPERATING_MODE_0,
            self::VALUE_OPERATING_MODE_1,
            self::VALUE_OPERATING_MODE_2,
            self::VALUE_OPERATING_MODE_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
