<?php

namespace EnumType;

/**
 * This class stands for ObstructionTypeEnum EnumType
 * @subpackage Enumerations
 */
class ObstructionTypeEnum
{
    /**
     * Constant for value 'airCrash'
     * @return string 'airCrash'
     */
    const VALUE_AIR_CRASH = 'airCrash';
    /**
     * Constant for value 'childrenOnRoadway'
     * @return string 'childrenOnRoadway'
     */
    const VALUE_CHILDREN_ON_ROADWAY = 'childrenOnRoadway';
    /**
     * Constant for value 'clearanceWork'
     * @return string 'clearanceWork'
     */
    const VALUE_CLEARANCE_WORK = 'clearanceWork';
    /**
     * Constant for value 'craneOperating'
     * @return string 'craneOperating'
     */
    const VALUE_CRANE_OPERATING = 'craneOperating';
    /**
     * Constant for value 'cyclistsOnRoadway'
     * @return string 'cyclistsOnRoadway'
     */
    const VALUE_CYCLISTS_ON_ROADWAY = 'cyclistsOnRoadway';
    /**
     * Constant for value 'debris'
     * @return string 'debris'
     */
    const VALUE_DEBRIS = 'debris';
    /**
     * Constant for value 'explosion'
     * @return string 'explosion'
     */
    const VALUE_EXPLOSION = 'explosion';
    /**
     * Constant for value 'explosionHazard'
     * @return string 'explosionHazard'
     */
    const VALUE_EXPLOSION_HAZARD = 'explosionHazard';
    /**
     * Constant for value 'hazardsOnTheRoad'
     * @return string 'hazardsOnTheRoad'
     */
    const VALUE_HAZARDS_ON_THE_ROAD = 'hazardsOnTheRoad';
    /**
     * Constant for value 'highSpeedChase'
     * @return string 'highSpeedChase'
     */
    const VALUE_HIGH_SPEED_CHASE = 'highSpeedChase';
    /**
     * Constant for value 'houseFire'
     * @return string 'houseFire'
     */
    const VALUE_HOUSE_FIRE = 'houseFire';
    /**
     * Constant for value 'incident'
     * @return string 'incident'
     */
    const VALUE_INCIDENT = 'incident';
    /**
     * Constant for value 'industrialAccident'
     * @return string 'industrialAccident'
     */
    const VALUE_INDUSTRIAL_ACCIDENT = 'industrialAccident';
    /**
     * Constant for value 'objectOnTheRoad'
     * @return string 'objectOnTheRoad'
     */
    const VALUE_OBJECT_ON_THE_ROAD = 'objectOnTheRoad';
    /**
     * Constant for value 'objectsFallingFromMovingVehicle'
     * @return string 'objectsFallingFromMovingVehicle'
     */
    const VALUE_OBJECTS_FALLING_FROM_MOVING_VEHICLE = 'objectsFallingFromMovingVehicle';
    /**
     * Constant for value 'obstructionOnTheRoad'
     * @return string 'obstructionOnTheRoad'
     */
    const VALUE_OBSTRUCTION_ON_THE_ROAD = 'obstructionOnTheRoad';
    /**
     * Constant for value 'peopleOnRoadway'
     * @return string 'peopleOnRoadway'
     */
    const VALUE_PEOPLE_ON_ROADWAY = 'peopleOnRoadway';
    /**
     * Constant for value 'railCrash'
     * @return string 'railCrash'
     */
    const VALUE_RAIL_CRASH = 'railCrash';
    /**
     * Constant for value 'recklessDriver'
     * @return string 'recklessDriver'
     */
    const VALUE_RECKLESS_DRIVER = 'recklessDriver';
    /**
     * Constant for value 'rescueAndRecoveryWork'
     * @return string 'rescueAndRecoveryWork'
     */
    const VALUE_RESCUE_AND_RECOVERY_WORK = 'rescueAndRecoveryWork';
    /**
     * Constant for value 'severeFrostDamagedRoadway'
     * @return string 'severeFrostDamagedRoadway'
     */
    const VALUE_SEVERE_FROST_DAMAGED_ROADWAY = 'severeFrostDamagedRoadway';
    /**
     * Constant for value 'shedLoad'
     * @return string 'shedLoad'
     */
    const VALUE_SHED_LOAD = 'shedLoad';
    /**
     * Constant for value 'snowAndIceDebris'
     * @return string 'snowAndIceDebris'
     */
    const VALUE_SNOW_AND_ICE_DEBRIS = 'snowAndIceDebris';
    /**
     * Constant for value 'spillageOccurringFromMovingVehicle'
     * @return string 'spillageOccurringFromMovingVehicle'
     */
    const VALUE_SPILLAGE_OCCURRING_FROM_MOVING_VEHICLE = 'spillageOccurringFromMovingVehicle';
    /**
     * Constant for value 'spillageOnTheRoad'
     * @return string 'spillageOnTheRoad'
     */
    const VALUE_SPILLAGE_ON_THE_ROAD = 'spillageOnTheRoad';
    /**
     * Constant for value 'unprotectedAccidentArea'
     * @return string 'unprotectedAccidentArea'
     */
    const VALUE_UNPROTECTED_ACCIDENT_AREA = 'unprotectedAccidentArea';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIR_CRASH
     * @uses self::VALUE_CHILDREN_ON_ROADWAY
     * @uses self::VALUE_CLEARANCE_WORK
     * @uses self::VALUE_CRANE_OPERATING
     * @uses self::VALUE_CYCLISTS_ON_ROADWAY
     * @uses self::VALUE_DEBRIS
     * @uses self::VALUE_EXPLOSION
     * @uses self::VALUE_EXPLOSION_HAZARD
     * @uses self::VALUE_HAZARDS_ON_THE_ROAD
     * @uses self::VALUE_HIGH_SPEED_CHASE
     * @uses self::VALUE_HOUSE_FIRE
     * @uses self::VALUE_INCIDENT
     * @uses self::VALUE_INDUSTRIAL_ACCIDENT
     * @uses self::VALUE_OBJECT_ON_THE_ROAD
     * @uses self::VALUE_OBJECTS_FALLING_FROM_MOVING_VEHICLE
     * @uses self::VALUE_OBSTRUCTION_ON_THE_ROAD
     * @uses self::VALUE_PEOPLE_ON_ROADWAY
     * @uses self::VALUE_RAIL_CRASH
     * @uses self::VALUE_RECKLESS_DRIVER
     * @uses self::VALUE_RESCUE_AND_RECOVERY_WORK
     * @uses self::VALUE_SEVERE_FROST_DAMAGED_ROADWAY
     * @uses self::VALUE_SHED_LOAD
     * @uses self::VALUE_SNOW_AND_ICE_DEBRIS
     * @uses self::VALUE_SPILLAGE_OCCURRING_FROM_MOVING_VEHICLE
     * @uses self::VALUE_SPILLAGE_ON_THE_ROAD
     * @uses self::VALUE_UNPROTECTED_ACCIDENT_AREA
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIR_CRASH,
            self::VALUE_CHILDREN_ON_ROADWAY,
            self::VALUE_CLEARANCE_WORK,
            self::VALUE_CRANE_OPERATING,
            self::VALUE_CYCLISTS_ON_ROADWAY,
            self::VALUE_DEBRIS,
            self::VALUE_EXPLOSION,
            self::VALUE_EXPLOSION_HAZARD,
            self::VALUE_HAZARDS_ON_THE_ROAD,
            self::VALUE_HIGH_SPEED_CHASE,
            self::VALUE_HOUSE_FIRE,
            self::VALUE_INCIDENT,
            self::VALUE_INDUSTRIAL_ACCIDENT,
            self::VALUE_OBJECT_ON_THE_ROAD,
            self::VALUE_OBJECTS_FALLING_FROM_MOVING_VEHICLE,
            self::VALUE_OBSTRUCTION_ON_THE_ROAD,
            self::VALUE_PEOPLE_ON_ROADWAY,
            self::VALUE_RAIL_CRASH,
            self::VALUE_RECKLESS_DRIVER,
            self::VALUE_RESCUE_AND_RECOVERY_WORK,
            self::VALUE_SEVERE_FROST_DAMAGED_ROADWAY,
            self::VALUE_SHED_LOAD,
            self::VALUE_SNOW_AND_ICE_DEBRIS,
            self::VALUE_SPILLAGE_OCCURRING_FROM_MOVING_VEHICLE,
            self::VALUE_SPILLAGE_ON_THE_ROAD,
            self::VALUE_UNPROTECTED_ACCIDENT_AREA,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
