<?php

namespace EnumType;

/**
 * This class stands for NonWeatherRelatedRoadConditionTypeEnum EnumType
 * @subpackage Enumerations
 */
class NonWeatherRelatedRoadConditionTypeEnum
{
    /**
     * Constant for value 'dieselOnRoad'
     * @return string 'dieselOnRoad'
     */
    const VALUE_DIESEL_ON_ROAD = 'dieselOnRoad';
    /**
     * Constant for value 'leavesOnRoad'
     * @return string 'leavesOnRoad'
     */
    const VALUE_LEAVES_ON_ROAD = 'leavesOnRoad';
    /**
     * Constant for value 'looseChippings'
     * @return string 'looseChippings'
     */
    const VALUE_LOOSE_CHIPPINGS = 'looseChippings';
    /**
     * Constant for value 'looseSandOnRoad'
     * @return string 'looseSandOnRoad'
     */
    const VALUE_LOOSE_SAND_ON_ROAD = 'looseSandOnRoad';
    /**
     * Constant for value 'mudOnRoad'
     * @return string 'mudOnRoad'
     */
    const VALUE_MUD_ON_ROAD = 'mudOnRoad';
    /**
     * Constant for value 'oilOnRoad'
     * @return string 'oilOnRoad'
     */
    const VALUE_OIL_ON_ROAD = 'oilOnRoad';
    /**
     * Constant for value 'petrolOnRoad'
     * @return string 'petrolOnRoad'
     */
    const VALUE_PETROL_ON_ROAD = 'petrolOnRoad';
    /**
     * Constant for value 'roadSurfaceInPoorCondition'
     * @return string 'roadSurfaceInPoorCondition'
     */
    const VALUE_ROAD_SURFACE_IN_POOR_CONDITION = 'roadSurfaceInPoorCondition';
    /**
     * Constant for value 'slipperyRoad'
     * @return string 'slipperyRoad'
     */
    const VALUE_SLIPPERY_ROAD = 'slipperyRoad';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DIESEL_ON_ROAD
     * @uses self::VALUE_LEAVES_ON_ROAD
     * @uses self::VALUE_LOOSE_CHIPPINGS
     * @uses self::VALUE_LOOSE_SAND_ON_ROAD
     * @uses self::VALUE_MUD_ON_ROAD
     * @uses self::VALUE_OIL_ON_ROAD
     * @uses self::VALUE_PETROL_ON_ROAD
     * @uses self::VALUE_ROAD_SURFACE_IN_POOR_CONDITION
     * @uses self::VALUE_SLIPPERY_ROAD
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DIESEL_ON_ROAD,
            self::VALUE_LEAVES_ON_ROAD,
            self::VALUE_LOOSE_CHIPPINGS,
            self::VALUE_LOOSE_SAND_ON_ROAD,
            self::VALUE_MUD_ON_ROAD,
            self::VALUE_OIL_ON_ROAD,
            self::VALUE_PETROL_ON_ROAD,
            self::VALUE_ROAD_SURFACE_IN_POOR_CONDITION,
            self::VALUE_SLIPPERY_ROAD,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
