<?php

namespace EnumType;

/**
 * This class stands for ModificationEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Classification of modification as addition, deletion or revision. Enumerated value.
 * @subpackage Enumerations
 */
class ModificationEnumeration
{
    /**
     * Constant for value 'new'
     * @return string 'new'
     */
    const VALUE_NEW = 'new';
    /**
     * Constant for value 'delete'
     * @return string 'delete'
     */
    const VALUE_DELETE = 'delete';
    /**
     * Constant for value 'revise'
     * @return string 'revise'
     */
    const VALUE_REVISE = 'revise';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEW
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_REVISE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW,
            self::VALUE_DELETE,
            self::VALUE_REVISE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
