<?php

namespace EnumType;

/**
 * This class stands for MobilityFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Mobility Facility: TPEG pti_table 23.
 * @subpackage Enumerations
 */
class MobilityFacilityEnumeration
{
    /**
     * Constant for value 'pti23_255_4'
     * @return string 'pti23_255_4'
     */
    const VALUE_PTI_23_255_4 = 'pti23_255_4';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti23_16'
     * @return string 'pti23_16'
     */
    const VALUE_PTI_23_16 = 'pti23_16';
    /**
     * Constant for value 'suitableForWheelChairs'
     * @return string 'suitableForWheelChairs'
     */
    const VALUE_SUITABLE_FOR_WHEEL_CHAIRS = 'suitableForWheelChairs';
    /**
     * Constant for value 'pti23_16_1'
     * @return string 'pti23_16_1'
     */
    const VALUE_PTI_23_16_1 = 'pti23_16_1';
    /**
     * Constant for value 'lowFloor'
     * @return string 'lowFloor'
     */
    const VALUE_LOW_FLOOR = 'lowFloor';
    /**
     * Constant for value 'pti23_16_2'
     * @return string 'pti23_16_2'
     */
    const VALUE_PTI_23_16_2_1 = 'pti23_16_2';
    /**
     * Constant for value 'boardingAssistance'
     * @return string 'boardingAssistance'
     */
    const VALUE_BOARDING_ASSISTANCE = 'boardingAssistance';
    /**
     * Constant for value 'pti23_16_3'
     * @return string 'pti23_16_3'
     */
    const VALUE_PTI_23_16_3 = 'pti23_16_3';
    /**
     * Constant for value 'stepFreeAccess'
     * @return string 'stepFreeAccess'
     */
    const VALUE_STEP_FREE_ACCESS = 'stepFreeAccess';
    /**
     * Constant for value 'tactilePatformEdges'
     * @return string 'tactilePatformEdges'
     */
    const VALUE_TACTILE_PATFORM_EDGES = 'tactilePatformEdges';
    /**
     * Constant for value 'onboardAssistance'
     * @return string 'onboardAssistance'
     */
    const VALUE_ONBOARD_ASSISTANCE = 'onboardAssistance';
    /**
     * Constant for value 'unaccompaniedMinorAssistance'
     * @return string 'unaccompaniedMinorAssistance'
     */
    const VALUE_UNACCOMPANIED_MINOR_ASSISTANCE = 'unaccompaniedMinorAssistance';
    /**
     * Constant for value 'audioInformation'
     * @return string 'audioInformation'
     */
    const VALUE_AUDIO_INFORMATION = 'audioInformation';
    /**
     * Constant for value 'visualInformation'
     * @return string 'visualInformation'
     */
    const VALUE_VISUAL_INFORMATION = 'visualInformation';
    /**
     * Constant for value 'displaysForVisuallyImpaired'
     * @return string 'displaysForVisuallyImpaired'
     */
    const VALUE_DISPLAYS_FOR_VISUALLY_IMPAIRED = 'displaysForVisuallyImpaired';
    /**
     * Constant for value 'audioForHearingImpaired'
     * @return string 'audioForHearingImpaired'
     */
    const VALUE_AUDIO_FOR_HEARING_IMPAIRED = 'audioForHearingImpaired';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_23_255_4
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_23_16_1
     * @uses self::VALUE_SUITABLE_FOR_WHEEL_CHAIRS
     * @uses self::VALUE_PTI_23_16_1
     * @uses self::VALUE_LOW_FLOOR
     * @uses self::VALUE_PTI_23_16_2_1
     * @uses self::VALUE_BOARDING_ASSISTANCE
     * @uses self::VALUE_PTI_23_16_3
     * @uses self::VALUE_STEP_FREE_ACCESS
     * @uses self::VALUE_TACTILE_PATFORM_EDGES
     * @uses self::VALUE_ONBOARD_ASSISTANCE
     * @uses self::VALUE_UNACCOMPANIED_MINOR_ASSISTANCE
     * @uses self::VALUE_AUDIO_INFORMATION
     * @uses self::VALUE_VISUAL_INFORMATION
     * @uses self::VALUE_DISPLAYS_FOR_VISUALLY_IMPAIRED
     * @uses self::VALUE_AUDIO_FOR_HEARING_IMPAIRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_23_255_4,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_23_16_1,
            self::VALUE_SUITABLE_FOR_WHEEL_CHAIRS,
            self::VALUE_PTI_23_16_1,
            self::VALUE_LOW_FLOOR,
            self::VALUE_PTI_23_16_2_1,
            self::VALUE_BOARDING_ASSISTANCE,
            self::VALUE_PTI_23_16_3,
            self::VALUE_STEP_FREE_ACCESS,
            self::VALUE_TACTILE_PATFORM_EDGES,
            self::VALUE_ONBOARD_ASSISTANCE,
            self::VALUE_UNACCOMPANIED_MINOR_ASSISTANCE,
            self::VALUE_AUDIO_INFORMATION,
            self::VALUE_VISUAL_INFORMATION,
            self::VALUE_DISPLAYS_FOR_VISUALLY_IMPAIRED,
            self::VALUE_AUDIO_FOR_HEARING_IMPAIRED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
