<?php

namespace EnumType;

/**
 * This class stands for MobilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Identification of mobility USER NEEDs.
 * @subpackage Enumerations
 */
class MobilityEnumeration
{
    /**
     * Constant for value 'wheelchair'
     * @return string 'wheelchair'
     */
    const VALUE_WHEELCHAIR = 'wheelchair';
    /**
     * Constant for value 'assistedWheelchair'
     * @return string 'assistedWheelchair'
     */
    const VALUE_ASSISTED_WHEELCHAIR = 'assistedWheelchair';
    /**
     * Constant for value 'motorizedWheelchair'
     * @return string 'motorizedWheelchair'
     */
    const VALUE_MOTORIZED_WHEELCHAIR = 'motorizedWheelchair';
    /**
     * Constant for value 'walkingFrame'
     * @return string 'walkingFrame'
     */
    const VALUE_WALKING_FRAME = 'walkingFrame';
    /**
     * Constant for value 'restrictedMobility'
     * @return string 'restrictedMobility'
     */
    const VALUE_RESTRICTED_MOBILITY = 'restrictedMobility';
    /**
     * Constant for value 'otherMobilityNeed'
     * @return string 'otherMobilityNeed'
     */
    const VALUE_OTHER_MOBILITY_NEED = 'otherMobilityNeed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WHEELCHAIR
     * @uses self::VALUE_ASSISTED_WHEELCHAIR
     * @uses self::VALUE_MOTORIZED_WHEELCHAIR
     * @uses self::VALUE_WALKING_FRAME
     * @uses self::VALUE_RESTRICTED_MOBILITY
     * @uses self::VALUE_OTHER_MOBILITY_NEED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WHEELCHAIR,
            self::VALUE_ASSISTED_WHEELCHAIR,
            self::VALUE_MOTORIZED_WHEELCHAIR,
            self::VALUE_WALKING_FRAME,
            self::VALUE_RESTRICTED_MOBILITY,
            self::VALUE_OTHER_MOBILITY_NEED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
