<?php

namespace EnumType;

/**
 * This class stands for MobilityEnum EnumType
 * @subpackage Enumerations
 */
class MobilityEnum
{
    /**
     * Constant for value 'mobile'
     * @return string 'mobile'
     */
    const VALUE_MOBILE = 'mobile';
    /**
     * Constant for value 'stationary'
     * @return string 'stationary'
     */
    const VALUE_STATIONARY = 'stationary';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MOBILE
     * @uses self::VALUE_STATIONARY
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MOBILE,
            self::VALUE_STATIONARY,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
