<?php

namespace EnumType;

/**
 * This class stands for MiscellaneousSubReasonEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Miscellaneous incident sub reason types.
 * @subpackage Enumerations
 */
class MiscellaneousSubReasonEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'previousDisturbances'
     * @return string 'previousDisturbances'
     */
    const VALUE_PREVIOUS_DISTURBANCES = 'previousDisturbances';
    /**
     * Constant for value 'incident'
     * @return string 'incident'
     */
    const VALUE_INCIDENT = 'incident';
    /**
     * Constant for value 'safetyViolation'
     * @return string 'safetyViolation'
     */
    const VALUE_SAFETY_VIOLATION = 'safetyViolation';
    /**
     * Constant for value 'nearMiss'
     * @return string 'nearMiss'
     */
    const VALUE_NEAR_MISS = 'nearMiss';
    /**
     * Constant for value 'signalPassedAtDanger'
     * @return string 'signalPassedAtDanger'
     */
    const VALUE_SIGNAL_PASSED_AT_DANGER = 'signalPassedAtDanger';
    /**
     * Constant for value 'stationOverrun'
     * @return string 'stationOverrun'
     */
    const VALUE_STATION_OVERRUN = 'stationOverrun';
    /**
     * Constant for value 'trainDoor'
     * @return string 'trainDoor'
     */
    const VALUE_TRAIN_DOOR = 'trainDoor';
    /**
     * Constant for value 'bombExplosion'
     * @return string 'bombExplosion'
     */
    const VALUE_BOMB_EXPLOSION = 'bombExplosion';
    /**
     * Constant for value 'securityAlert'
     * @return string 'securityAlert'
     */
    const VALUE_SECURITY_ALERT = 'securityAlert';
    /**
     * Constant for value 'emergencyServicesCall'
     * @return string 'emergencyServicesCall'
     */
    const VALUE_EMERGENCY_SERVICES_CALL = 'emergencyServicesCall';
    /**
     * Constant for value 'policeRequest'
     * @return string 'policeRequest'
     */
    const VALUE_POLICE_REQUEST = 'policeRequest';
    /**
     * Constant for value 'fireBrigadeSafetyChecks'
     * @return string 'fireBrigadeSafetyChecks'
     */
    const VALUE_FIRE_BRIGADE_SAFETY_CHECKS = 'fireBrigadeSafetyChecks';
    /**
     * Constant for value 'unattendedBag'
     * @return string 'unattendedBag'
     */
    const VALUE_UNATTENDED_BAG = 'unattendedBag';
    /**
     * Constant for value 'telephonedThreat'
     * @return string 'telephonedThreat'
     */
    const VALUE_TELEPHONED_THREAT = 'telephonedThreat';
    /**
     * Constant for value 'suspectVehicle'
     * @return string 'suspectVehicle'
     */
    const VALUE_SUSPECT_VEHICLE = 'suspectVehicle';
    /**
     * Constant for value 'civilEmergency'
     * @return string 'civilEmergency'
     */
    const VALUE_CIVIL_EMERGENCY = 'civilEmergency';
    /**
     * Constant for value 'airRaid'
     * @return string 'airRaid'
     */
    const VALUE_AIR_RAID = 'airRaid';
    /**
     * Constant for value 'sabotage'
     * @return string 'sabotage'
     */
    const VALUE_SABOTAGE = 'sabotage';
    /**
     * Constant for value 'bombALert'
     * @return string 'bombALert'
     */
    const VALUE_BOMB_ALERT = 'bombALert';
    /**
     * Constant for value 'attack'
     * @return string 'attack'
     */
    const VALUE_ATTACK = 'attack';
    /**
     * Constant for value 'evacuation'
     * @return string 'evacuation'
     */
    const VALUE_EVACUATION = 'evacuation';
    /**
     * Constant for value 'terroristIncident'
     * @return string 'terroristIncident'
     */
    const VALUE_TERRORIST_INCIDENT = 'terroristIncident';
    /**
     * Constant for value 'gunfireOnRoadway'
     * @return string 'gunfireOnRoadway'
     */
    const VALUE_GUNFIRE_ON_ROADWAY = 'gunfireOnRoadway';
    /**
     * Constant for value 'explosion'
     * @return string 'explosion'
     */
    const VALUE_EXPLOSION = 'explosion';
    /**
     * Constant for value 'explosionHazard'
     * @return string 'explosionHazard'
     */
    const VALUE_EXPLOSION_HAZARD = 'explosionHazard';
    /**
     * Constant for value 'securityIncident'
     * @return string 'securityIncident'
     */
    const VALUE_SECURITY_INCIDENT = 'securityIncident';
    /**
     * Constant for value 'fireBrigadeOrder'
     * @return string 'fireBrigadeOrder'
     */
    const VALUE_FIRE_BRIGADE_ORDER = 'fireBrigadeOrder';
    /**
     * Constant for value 'policeActivity'
     * @return string 'policeActivity'
     */
    const VALUE_POLICE_ACTIVITY = 'policeActivity';
    /**
     * Constant for value 'fire'
     * @return string 'fire'
     */
    const VALUE_FIRE = 'fire';
    /**
     * Constant for value 'linesideFire'
     * @return string 'linesideFire'
     */
    const VALUE_LINESIDE_FIRE = 'linesideFire';
    /**
     * Constant for value 'vandalism'
     * @return string 'vandalism'
     */
    const VALUE_VANDALISM = 'vandalism';
    /**
     * Constant for value 'passengerAction'
     * @return string 'passengerAction'
     */
    const VALUE_PASSENGER_ACTION = 'passengerAction';
    /**
     * Constant for value 'staffAssault'
     * @return string 'staffAssault'
     */
    const VALUE_STAFF_ASSAULT = 'staffAssault';
    /**
     * Constant for value 'railwayCrime'
     * @return string 'railwayCrime'
     */
    const VALUE_RAILWAY_CRIME = 'railwayCrime';
    /**
     * Constant for value 'theft'
     * @return string 'theft'
     */
    const VALUE_THEFT = 'theft';
    /**
     * Constant for value 'altercation'
     * @return string 'altercation'
     */
    const VALUE_ALTERCATION = 'altercation';
    /**
     * Constant for value 'illVehicleOccupants'
     * @return string 'illVehicleOccupants'
     */
    const VALUE_ILL_VEHICLE_OCCUPANTS = 'illVehicleOccupants';
    /**
     * Constant for value 'accident'
     * @return string 'accident'
     */
    const VALUE_ACCIDENT = 'accident';
    /**
     * Constant for value 'fatality'
     * @return string 'fatality'
     */
    const VALUE_FATALITY = 'fatality';
    /**
     * Constant for value 'personUnderTrain'
     * @return string 'personUnderTrain'
     */
    const VALUE_PERSON_UNDER_TRAIN = 'personUnderTrain';
    /**
     * Constant for value 'personHitByTrain'
     * @return string 'personHitByTrain'
     */
    const VALUE_PERSON_HIT_BY_TRAIN = 'personHitByTrain';
    /**
     * Constant for value 'personIllOnVehicle'
     * @return string 'personIllOnVehicle'
     */
    const VALUE_PERSON_ILL_ON_VEHICLE = 'personIllOnVehicle';
    /**
     * Constant for value 'emergencyServices'
     * @return string 'emergencyServices'
     */
    const VALUE_EMERGENCY_SERVICES = 'emergencyServices';
    /**
     * Constant for value 'collision'
     * @return string 'collision'
     */
    const VALUE_COLLISION = 'collision';
    /**
     * Constant for value 'overcrowded'
     * @return string 'overcrowded'
     */
    const VALUE_OVERCROWDED = 'overcrowded';
    /**
     * Constant for value 'insufficientDemand'
     * @return string 'insufficientDemand'
     */
    const VALUE_INSUFFICIENT_DEMAND = 'insufficientDemand';
    /**
     * Constant for value 'lightingFailure'
     * @return string 'lightingFailure'
     */
    const VALUE_LIGHTING_FAILURE = 'lightingFailure';
    /**
     * Constant for value 'leaderBoardFailure'
     * @return string 'leaderBoardFailure'
     */
    const VALUE_LEADER_BOARD_FAILURE = 'leaderBoardFailure';
    /**
     * Constant for value 'serviceIndicatorFailure'
     * @return string 'serviceIndicatorFailure'
     */
    const VALUE_SERVICE_INDICATOR_FAILURE = 'serviceIndicatorFailure';
    /**
     * Constant for value 'serviceFailure'
     * @return string 'serviceFailure'
     */
    const VALUE_SERVICE_FAILURE = 'serviceFailure';
    /**
     * Constant for value 'operatorCeasedTrading'
     * @return string 'operatorCeasedTrading'
     */
    const VALUE_OPERATOR_CEASED_TRADING = 'operatorCeasedTrading';
    /**
     * Constant for value 'operatorSuspended'
     * @return string 'operatorSuspended'
     */
    const VALUE_OPERATOR_SUSPENDED = 'operatorSuspended';
    /**
     * Constant for value 'congestion'
     * @return string 'congestion'
     */
    const VALUE_CONGESTION = 'congestion';
    /**
     * Constant for value 'routeBlockage'
     * @return string 'routeBlockage'
     */
    const VALUE_ROUTE_BLOCKAGE = 'routeBlockage';
    /**
     * Constant for value 'personOnTheLine'
     * @return string 'personOnTheLine'
     */
    const VALUE_PERSON_ON_THE_LINE = 'personOnTheLine';
    /**
     * Constant for value 'vehicleOnTheLine'
     * @return string 'vehicleOnTheLine'
     */
    const VALUE_VEHICLE_ON_THE_LINE = 'vehicleOnTheLine';
    /**
     * Constant for value 'objectOnTheLine'
     * @return string 'objectOnTheLine'
     */
    const VALUE_OBJECT_ON_THE_LINE = 'objectOnTheLine';
    /**
     * Constant for value 'fallenTreeOnTheLine'
     * @return string 'fallenTreeOnTheLine'
     */
    const VALUE_FALLEN_TREE_ON_THE_LINE = 'fallenTreeOnTheLine';
    /**
     * Constant for value 'vegetation'
     * @return string 'vegetation'
     */
    const VALUE_VEGETATION = 'vegetation';
    /**
     * Constant for value 'trainStruckAnimal'
     * @return string 'trainStruckAnimal'
     */
    const VALUE_TRAIN_STRUCK_ANIMAL = 'trainStruckAnimal';
    /**
     * Constant for value 'trainStruckObject'
     * @return string 'trainStruckObject'
     */
    const VALUE_TRAIN_STRUCK_OBJECT = 'trainStruckObject';
    /**
     * Constant for value 'levelCrossingIncident'
     * @return string 'levelCrossingIncident'
     */
    const VALUE_LEVEL_CROSSING_INCIDENT = 'levelCrossingIncident';
    /**
     * Constant for value 'animalOnTheLine'
     * @return string 'animalOnTheLine'
     */
    const VALUE_ANIMAL_ON_THE_LINE = 'animalOnTheLine';
    /**
     * Constant for value 'routeDiversion'
     * @return string 'routeDiversion'
     */
    const VALUE_ROUTE_DIVERSION = 'routeDiversion';
    /**
     * Constant for value 'roadClosed'
     * @return string 'roadClosed'
     */
    const VALUE_ROAD_CLOSED = 'roadClosed';
    /**
     * Constant for value 'roadworks'
     * @return string 'roadworks'
     */
    const VALUE_ROADWORKS = 'roadworks';
    /**
     * Constant for value 'sewerageMaintenance'
     * @return string 'sewerageMaintenance'
     */
    const VALUE_SEWERAGE_MAINTENANCE = 'sewerageMaintenance';
    /**
     * Constant for value 'roadMaintenance'
     * @return string 'roadMaintenance'
     */
    const VALUE_ROAD_MAINTENANCE = 'roadMaintenance';
    /**
     * Constant for value 'asphalting'
     * @return string 'asphalting'
     */
    const VALUE_ASPHALTING = 'asphalting';
    /**
     * Constant for value 'paving'
     * @return string 'paving'
     */
    const VALUE_PAVING = 'paving';
    /**
     * Constant for value 'specialEvent'
     * @return string 'specialEvent'
     */
    const VALUE_SPECIAL_EVENT = 'specialEvent';
    /**
     * Constant for value 'march'
     * @return string 'march'
     */
    const VALUE_MARCH = 'march';
    /**
     * Constant for value 'procession'
     * @return string 'procession'
     */
    const VALUE_PROCESSION = 'procession';
    /**
     * Constant for value 'demonstration'
     * @return string 'demonstration'
     */
    const VALUE_DEMONSTRATION = 'demonstration';
    /**
     * Constant for value 'publicDisturbance'
     * @return string 'publicDisturbance'
     */
    const VALUE_PUBLIC_DISTURBANCE = 'publicDisturbance';
    /**
     * Constant for value 'filterBlockade'
     * @return string 'filterBlockade'
     */
    const VALUE_FILTER_BLOCKADE = 'filterBlockade';
    /**
     * Constant for value 'sightseersObstructingAccess'
     * @return string 'sightseersObstructingAccess'
     */
    const VALUE_SIGHTSEERS_OBSTRUCTING_ACCESS = 'sightseersObstructingAccess';
    /**
     * Constant for value 'holiday'
     * @return string 'holiday'
     */
    const VALUE_HOLIDAY = 'holiday';
    /**
     * Constant for value 'bridgeStrike'
     * @return string 'bridgeStrike'
     */
    const VALUE_BRIDGE_STRIKE = 'bridgeStrike';
    /**
     * Constant for value 'viaductFailure'
     * @return string 'viaductFailure'
     */
    const VALUE_VIADUCT_FAILURE = 'viaductFailure';
    /**
     * Constant for value 'overheadObstruction'
     * @return string 'overheadObstruction'
     */
    const VALUE_OVERHEAD_OBSTRUCTION = 'overheadObstruction';
    /**
     * Constant for value 'undefinedProblem'
     * @return string 'undefinedProblem'
     */
    const VALUE_UNDEFINED_PROBLEM = 'undefinedProblem';
    /**
     * Constant for value 'problemsAtBorderPost'
     * @return string 'problemsAtBorderPost'
     */
    const VALUE_PROBLEMS_AT_BORDER_POST = 'problemsAtBorderPost';
    /**
     * Constant for value 'problemsAtCustomsPost'
     * @return string 'problemsAtCustomsPost'
     */
    const VALUE_PROBLEMS_AT_CUSTOMS_POST = 'problemsAtCustomsPost';
    /**
     * Constant for value 'problemsOnLocalRoad'
     * @return string 'problemsOnLocalRoad'
     */
    const VALUE_PROBLEMS_ON_LOCAL_ROAD = 'problemsOnLocalRoad';
    /**
     * Constant for value 'speedRestrictions'
     * @return string 'speedRestrictions'
     */
    const VALUE_SPEED_RESTRICTIONS = 'speedRestrictions';
    /**
     * Constant for value 'logisticProblems'
     * @return string 'logisticProblems'
     */
    const VALUE_LOGISTIC_PROBLEMS = 'logisticProblems';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PREVIOUS_DISTURBANCES
     * @uses self::VALUE_INCIDENT
     * @uses self::VALUE_SAFETY_VIOLATION
     * @uses self::VALUE_NEAR_MISS
     * @uses self::VALUE_SIGNAL_PASSED_AT_DANGER
     * @uses self::VALUE_STATION_OVERRUN
     * @uses self::VALUE_TRAIN_DOOR
     * @uses self::VALUE_BOMB_EXPLOSION
     * @uses self::VALUE_SECURITY_ALERT
     * @uses self::VALUE_EMERGENCY_SERVICES_CALL
     * @uses self::VALUE_POLICE_REQUEST
     * @uses self::VALUE_FIRE_BRIGADE_SAFETY_CHECKS
     * @uses self::VALUE_UNATTENDED_BAG
     * @uses self::VALUE_TELEPHONED_THREAT
     * @uses self::VALUE_SUSPECT_VEHICLE
     * @uses self::VALUE_CIVIL_EMERGENCY
     * @uses self::VALUE_AIR_RAID
     * @uses self::VALUE_SABOTAGE
     * @uses self::VALUE_BOMB_ALERT
     * @uses self::VALUE_ATTACK
     * @uses self::VALUE_EVACUATION
     * @uses self::VALUE_TERRORIST_INCIDENT
     * @uses self::VALUE_GUNFIRE_ON_ROADWAY
     * @uses self::VALUE_EXPLOSION
     * @uses self::VALUE_EXPLOSION_HAZARD
     * @uses self::VALUE_SECURITY_INCIDENT
     * @uses self::VALUE_FIRE_BRIGADE_ORDER
     * @uses self::VALUE_POLICE_ACTIVITY
     * @uses self::VALUE_FIRE
     * @uses self::VALUE_LINESIDE_FIRE
     * @uses self::VALUE_VANDALISM
     * @uses self::VALUE_PASSENGER_ACTION
     * @uses self::VALUE_STAFF_ASSAULT
     * @uses self::VALUE_RAILWAY_CRIME
     * @uses self::VALUE_THEFT
     * @uses self::VALUE_ALTERCATION
     * @uses self::VALUE_ILL_VEHICLE_OCCUPANTS
     * @uses self::VALUE_ACCIDENT
     * @uses self::VALUE_FATALITY
     * @uses self::VALUE_PERSON_UNDER_TRAIN
     * @uses self::VALUE_PERSON_HIT_BY_TRAIN
     * @uses self::VALUE_PERSON_ILL_ON_VEHICLE
     * @uses self::VALUE_EMERGENCY_SERVICES
     * @uses self::VALUE_COLLISION
     * @uses self::VALUE_OVERCROWDED
     * @uses self::VALUE_INSUFFICIENT_DEMAND
     * @uses self::VALUE_LIGHTING_FAILURE
     * @uses self::VALUE_LEADER_BOARD_FAILURE
     * @uses self::VALUE_SERVICE_INDICATOR_FAILURE
     * @uses self::VALUE_SERVICE_FAILURE
     * @uses self::VALUE_OPERATOR_CEASED_TRADING
     * @uses self::VALUE_OPERATOR_SUSPENDED
     * @uses self::VALUE_CONGESTION
     * @uses self::VALUE_ROUTE_BLOCKAGE
     * @uses self::VALUE_PERSON_ON_THE_LINE
     * @uses self::VALUE_VEHICLE_ON_THE_LINE
     * @uses self::VALUE_OBJECT_ON_THE_LINE
     * @uses self::VALUE_FALLEN_TREE_ON_THE_LINE
     * @uses self::VALUE_VEGETATION
     * @uses self::VALUE_TRAIN_STRUCK_ANIMAL
     * @uses self::VALUE_TRAIN_STRUCK_OBJECT
     * @uses self::VALUE_LEVEL_CROSSING_INCIDENT
     * @uses self::VALUE_ANIMAL_ON_THE_LINE
     * @uses self::VALUE_ROUTE_DIVERSION
     * @uses self::VALUE_ROAD_CLOSED
     * @uses self::VALUE_ROADWORKS
     * @uses self::VALUE_SEWERAGE_MAINTENANCE
     * @uses self::VALUE_ROAD_MAINTENANCE
     * @uses self::VALUE_ASPHALTING
     * @uses self::VALUE_PAVING
     * @uses self::VALUE_SPECIAL_EVENT
     * @uses self::VALUE_MARCH
     * @uses self::VALUE_PROCESSION
     * @uses self::VALUE_DEMONSTRATION
     * @uses self::VALUE_PUBLIC_DISTURBANCE
     * @uses self::VALUE_FILTER_BLOCKADE
     * @uses self::VALUE_SIGHTSEERS_OBSTRUCTING_ACCESS
     * @uses self::VALUE_HOLIDAY
     * @uses self::VALUE_BRIDGE_STRIKE
     * @uses self::VALUE_VIADUCT_FAILURE
     * @uses self::VALUE_OVERHEAD_OBSTRUCTION
     * @uses self::VALUE_UNDEFINED_PROBLEM
     * @uses self::VALUE_PROBLEMS_AT_BORDER_POST
     * @uses self::VALUE_PROBLEMS_AT_CUSTOMS_POST
     * @uses self::VALUE_PROBLEMS_ON_LOCAL_ROAD
     * @uses self::VALUE_SPEED_RESTRICTIONS
     * @uses self::VALUE_LOGISTIC_PROBLEMS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_PREVIOUS_DISTURBANCES,
            self::VALUE_INCIDENT,
            self::VALUE_SAFETY_VIOLATION,
            self::VALUE_NEAR_MISS,
            self::VALUE_SIGNAL_PASSED_AT_DANGER,
            self::VALUE_STATION_OVERRUN,
            self::VALUE_TRAIN_DOOR,
            self::VALUE_BOMB_EXPLOSION,
            self::VALUE_SECURITY_ALERT,
            self::VALUE_EMERGENCY_SERVICES_CALL,
            self::VALUE_POLICE_REQUEST,
            self::VALUE_FIRE_BRIGADE_SAFETY_CHECKS,
            self::VALUE_UNATTENDED_BAG,
            self::VALUE_TELEPHONED_THREAT,
            self::VALUE_SUSPECT_VEHICLE,
            self::VALUE_CIVIL_EMERGENCY,
            self::VALUE_AIR_RAID,
            self::VALUE_SABOTAGE,
            self::VALUE_BOMB_ALERT,
            self::VALUE_ATTACK,
            self::VALUE_EVACUATION,
            self::VALUE_TERRORIST_INCIDENT,
            self::VALUE_GUNFIRE_ON_ROADWAY,
            self::VALUE_EXPLOSION,
            self::VALUE_EXPLOSION_HAZARD,
            self::VALUE_SECURITY_INCIDENT,
            self::VALUE_FIRE_BRIGADE_ORDER,
            self::VALUE_POLICE_ACTIVITY,
            self::VALUE_FIRE,
            self::VALUE_LINESIDE_FIRE,
            self::VALUE_VANDALISM,
            self::VALUE_PASSENGER_ACTION,
            self::VALUE_STAFF_ASSAULT,
            self::VALUE_RAILWAY_CRIME,
            self::VALUE_THEFT,
            self::VALUE_ALTERCATION,
            self::VALUE_ILL_VEHICLE_OCCUPANTS,
            self::VALUE_ACCIDENT,
            self::VALUE_FATALITY,
            self::VALUE_PERSON_UNDER_TRAIN,
            self::VALUE_PERSON_HIT_BY_TRAIN,
            self::VALUE_PERSON_ILL_ON_VEHICLE,
            self::VALUE_EMERGENCY_SERVICES,
            self::VALUE_COLLISION,
            self::VALUE_OVERCROWDED,
            self::VALUE_INSUFFICIENT_DEMAND,
            self::VALUE_LIGHTING_FAILURE,
            self::VALUE_LEADER_BOARD_FAILURE,
            self::VALUE_SERVICE_INDICATOR_FAILURE,
            self::VALUE_SERVICE_FAILURE,
            self::VALUE_OPERATOR_CEASED_TRADING,
            self::VALUE_OPERATOR_SUSPENDED,
            self::VALUE_CONGESTION,
            self::VALUE_ROUTE_BLOCKAGE,
            self::VALUE_PERSON_ON_THE_LINE,
            self::VALUE_VEHICLE_ON_THE_LINE,
            self::VALUE_OBJECT_ON_THE_LINE,
            self::VALUE_FALLEN_TREE_ON_THE_LINE,
            self::VALUE_VEGETATION,
            self::VALUE_TRAIN_STRUCK_ANIMAL,
            self::VALUE_TRAIN_STRUCK_OBJECT,
            self::VALUE_LEVEL_CROSSING_INCIDENT,
            self::VALUE_ANIMAL_ON_THE_LINE,
            self::VALUE_ROUTE_DIVERSION,
            self::VALUE_ROAD_CLOSED,
            self::VALUE_ROADWORKS,
            self::VALUE_SEWERAGE_MAINTENANCE,
            self::VALUE_ROAD_MAINTENANCE,
            self::VALUE_ASPHALTING,
            self::VALUE_PAVING,
            self::VALUE_SPECIAL_EVENT,
            self::VALUE_MARCH,
            self::VALUE_PROCESSION,
            self::VALUE_DEMONSTRATION,
            self::VALUE_PUBLIC_DISTURBANCE,
            self::VALUE_FILTER_BLOCKADE,
            self::VALUE_SIGHTSEERS_OBSTRUCTING_ACCESS,
            self::VALUE_HOLIDAY,
            self::VALUE_BRIDGE_STRIKE,
            self::VALUE_VIADUCT_FAILURE,
            self::VALUE_OVERHEAD_OBSTRUCTION,
            self::VALUE_UNDEFINED_PROBLEM,
            self::VALUE_PROBLEMS_AT_BORDER_POST,
            self::VALUE_PROBLEMS_AT_CUSTOMS_POST,
            self::VALUE_PROBLEMS_ON_LOCAL_ROAD,
            self::VALUE_SPEED_RESTRICTIONS,
            self::VALUE_LOGISTIC_PROBLEMS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
