<?php

namespace EnumType;

/**
 * This class stands for MeasuredOrDerivedDataTypeEnum EnumType
 * @subpackage Enumerations
 */
class MeasuredOrDerivedDataTypeEnum
{
    /**
     * Constant for value 'humidityInformation'
     * @return string 'humidityInformation'
     */
    const VALUE_HUMIDITY_INFORMATION = 'humidityInformation';
    /**
     * Constant for value 'individualVehicleMeasurements'
     * @return string 'individualVehicleMeasurements'
     */
    const VALUE_INDIVIDUAL_VEHICLE_MEASUREMENTS = 'individualVehicleMeasurements';
    /**
     * Constant for value 'pollutionInformation'
     * @return string 'pollutionInformation'
     */
    const VALUE_POLLUTION_INFORMATION = 'pollutionInformation';
    /**
     * Constant for value 'precipitationInformation'
     * @return string 'precipitationInformation'
     */
    const VALUE_PRECIPITATION_INFORMATION = 'precipitationInformation';
    /**
     * Constant for value 'pressureInformation'
     * @return string 'pressureInformation'
     */
    const VALUE_PRESSURE_INFORMATION = 'pressureInformation';
    /**
     * Constant for value 'radiationInformation'
     * @return string 'radiationInformation'
     */
    const VALUE_RADIATION_INFORMATION = 'radiationInformation';
    /**
     * Constant for value 'roadSurfaceConditionInformation'
     * @return string 'roadSurfaceConditionInformation'
     */
    const VALUE_ROAD_SURFACE_CONDITION_INFORMATION = 'roadSurfaceConditionInformation';
    /**
     * Constant for value 'temperatureInformation'
     * @return string 'temperatureInformation'
     */
    const VALUE_TEMPERATURE_INFORMATION = 'temperatureInformation';
    /**
     * Constant for value 'trafficConcentration'
     * @return string 'trafficConcentration'
     */
    const VALUE_TRAFFIC_CONCENTRATION = 'trafficConcentration';
    /**
     * Constant for value 'trafficFlow'
     * @return string 'trafficFlow'
     */
    const VALUE_TRAFFIC_FLOW = 'trafficFlow';
    /**
     * Constant for value 'trafficHeadway'
     * @return string 'trafficHeadway'
     */
    const VALUE_TRAFFIC_HEADWAY = 'trafficHeadway';
    /**
     * Constant for value 'trafficSpeed'
     * @return string 'trafficSpeed'
     */
    const VALUE_TRAFFIC_SPEED = 'trafficSpeed';
    /**
     * Constant for value 'trafficStatusInformation'
     * @return string 'trafficStatusInformation'
     */
    const VALUE_TRAFFIC_STATUS_INFORMATION = 'trafficStatusInformation';
    /**
     * Constant for value 'travelTimeInformation'
     * @return string 'travelTimeInformation'
     */
    const VALUE_TRAVEL_TIME_INFORMATION = 'travelTimeInformation';
    /**
     * Constant for value 'visibilityInformation'
     * @return string 'visibilityInformation'
     */
    const VALUE_VISIBILITY_INFORMATION = 'visibilityInformation';
    /**
     * Constant for value 'windInformation'
     * @return string 'windInformation'
     */
    const VALUE_WIND_INFORMATION = 'windInformation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HUMIDITY_INFORMATION
     * @uses self::VALUE_INDIVIDUAL_VEHICLE_MEASUREMENTS
     * @uses self::VALUE_POLLUTION_INFORMATION
     * @uses self::VALUE_PRECIPITATION_INFORMATION
     * @uses self::VALUE_PRESSURE_INFORMATION
     * @uses self::VALUE_RADIATION_INFORMATION
     * @uses self::VALUE_ROAD_SURFACE_CONDITION_INFORMATION
     * @uses self::VALUE_TEMPERATURE_INFORMATION
     * @uses self::VALUE_TRAFFIC_CONCENTRATION
     * @uses self::VALUE_TRAFFIC_FLOW
     * @uses self::VALUE_TRAFFIC_HEADWAY
     * @uses self::VALUE_TRAFFIC_SPEED
     * @uses self::VALUE_TRAFFIC_STATUS_INFORMATION
     * @uses self::VALUE_TRAVEL_TIME_INFORMATION
     * @uses self::VALUE_VISIBILITY_INFORMATION
     * @uses self::VALUE_WIND_INFORMATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HUMIDITY_INFORMATION,
            self::VALUE_INDIVIDUAL_VEHICLE_MEASUREMENTS,
            self::VALUE_POLLUTION_INFORMATION,
            self::VALUE_PRECIPITATION_INFORMATION,
            self::VALUE_PRESSURE_INFORMATION,
            self::VALUE_RADIATION_INFORMATION,
            self::VALUE_ROAD_SURFACE_CONDITION_INFORMATION,
            self::VALUE_TEMPERATURE_INFORMATION,
            self::VALUE_TRAFFIC_CONCENTRATION,
            self::VALUE_TRAFFIC_FLOW,
            self::VALUE_TRAFFIC_HEADWAY,
            self::VALUE_TRAFFIC_SPEED,
            self::VALUE_TRAFFIC_STATUS_INFORMATION,
            self::VALUE_TRAVEL_TIME_INFORMATION,
            self::VALUE_VISIBILITY_INFORMATION,
            self::VALUE_WIND_INFORMATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
