<?php

namespace EnumType;

/**
 * This class stands for LinkContentEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for image content.
 * @subpackage Enumerations
 */
class LinkContentEnumeration
{
    /**
     * Constant for value 'timetable'
     * @return string 'timetable'
     */
    const VALUE_TIMETABLE = 'timetable';
    /**
     * Constant for value 'relatedSite'
     * @return string 'relatedSite'
     */
    const VALUE_RELATED_SITE = 'relatedSite';
    /**
     * Constant for value 'details'
     * @return string 'details'
     */
    const VALUE_DETAILS = 'details';
    /**
     * Constant for value 'advice'
     * @return string 'advice'
     */
    const VALUE_ADVICE = 'advice';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TIMETABLE
     * @uses self::VALUE_RELATED_SITE
     * @uses self::VALUE_DETAILS
     * @uses self::VALUE_ADVICE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TIMETABLE,
            self::VALUE_RELATED_SITE,
            self::VALUE_DETAILS,
            self::VALUE_ADVICE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
