<?php

namespace EnumType;

/**
 * This class stands for InvolvementRolesEnum EnumType
 * @subpackage Enumerations
 */
class InvolvementRolesEnum
{
    /**
     * Constant for value 'cyclist'
     * @return string 'cyclist'
     */
    const VALUE_CYCLIST = 'cyclist';
    /**
     * Constant for value 'pedestrian'
     * @return string 'pedestrian'
     */
    const VALUE_PEDESTRIAN = 'pedestrian';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'vehicleDriver'
     * @return string 'vehicleDriver'
     */
    const VALUE_VEHICLE_DRIVER = 'vehicleDriver';
    /**
     * Constant for value 'vehicleOccupant'
     * @return string 'vehicleOccupant'
     */
    const VALUE_VEHICLE_OCCUPANT = 'vehicleOccupant';
    /**
     * Constant for value 'vehiclePassenger'
     * @return string 'vehiclePassenger'
     */
    const VALUE_VEHICLE_PASSENGER = 'vehiclePassenger';
    /**
     * Constant for value 'witness'
     * @return string 'witness'
     */
    const VALUE_WITNESS = 'witness';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CYCLIST
     * @uses self::VALUE_PEDESTRIAN
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_VEHICLE_DRIVER
     * @uses self::VALUE_VEHICLE_OCCUPANT
     * @uses self::VALUE_VEHICLE_PASSENGER
     * @uses self::VALUE_WITNESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CYCLIST,
            self::VALUE_PEDESTRIAN,
            self::VALUE_UNKNOWN,
            self::VALUE_VEHICLE_DRIVER,
            self::VALUE_VEHICLE_OCCUPANT,
            self::VALUE_VEHICLE_PASSENGER,
            self::VALUE_WITNESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
