<?php

namespace EnumType;

/**
 * This class stands for InterchangeWeightingEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of Interchange Weighting.
 * @subpackage Enumerations
 */
class InterchangeWeightingEnumeration
{
    /**
     * Constant for value 'noInterchange'
     * @return string 'noInterchange'
     */
    const VALUE_NO_INTERCHANGE = 'noInterchange';
    /**
     * Constant for value 'interchangeAllowed'
     * @return string 'interchangeAllowed'
     */
    const VALUE_INTERCHANGE_ALLOWED = 'interchangeAllowed';
    /**
     * Constant for value 'recommendedInterchange'
     * @return string 'recommendedInterchange'
     */
    const VALUE_RECOMMENDED_INTERCHANGE = 'recommendedInterchange';
    /**
     * Constant for value 'preferredInterchange'
     * @return string 'preferredInterchange'
     */
    const VALUE_PREFERRED_INTERCHANGE = 'preferredInterchange';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_INTERCHANGE
     * @uses self::VALUE_INTERCHANGE_ALLOWED
     * @uses self::VALUE_RECOMMENDED_INTERCHANGE
     * @uses self::VALUE_PREFERRED_INTERCHANGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_INTERCHANGE,
            self::VALUE_INTERCHANGE_ALLOWED,
            self::VALUE_RECOMMENDED_INTERCHANGE,
            self::VALUE_PREFERRED_INTERCHANGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
