<?php

namespace EnumType;

/**
 * This class stands for HolidayTypeEnumerationx EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Day Type TPEG pti_table 34
 * @subpackage Enumerations
 */
class HolidayTypeEnumerationx
{
    /**
     * Constant for value 'holiday'
     * @return string 'holiday'
     */
    const VALUE_HOLIDAY = 'holiday';
    /**
     * Constant for value 'publicHoliday'
     * @return string 'publicHoliday'
     */
    const VALUE_PUBLIC_HOLIDAY = 'publicHoliday';
    /**
     * Constant for value 'religiousHoliday'
     * @return string 'religiousHoliday'
     */
    const VALUE_RELIGIOUS_HOLIDAY = 'religiousHoliday';
    /**
     * Constant for value 'federalHoliday'
     * @return string 'federalHoliday'
     */
    const VALUE_FEDERAL_HOLIDAY = 'federalHoliday';
    /**
     * Constant for value 'regionalHoliday'
     * @return string 'regionalHoliday'
     */
    const VALUE_REGIONAL_HOLIDAY = 'regionalHoliday';
    /**
     * Constant for value 'nationalHoliday'
     * @return string 'nationalHoliday'
     */
    const VALUE_NATIONAL_HOLIDAY = 'nationalHoliday';
    /**
     * Constant for value 'sundaysAndPublicHolidays'
     * @return string 'sundaysAndPublicHolidays'
     */
    const VALUE_SUNDAYS_AND_PUBLIC_HOLIDAYS = 'sundaysAndPublicHolidays';
    /**
     * Constant for value 'schoolDays'
     * @return string 'schoolDays'
     */
    const VALUE_SCHOOL_DAYS = 'schoolDays';
    /**
     * Constant for value 'everyDay'
     * @return string 'everyDay'
     */
    const VALUE_EVERY_DAY = 'everyDay';
    /**
     * Constant for value 'undefinedDayType'
     * @return string 'undefinedDayType'
     */
    const VALUE_UNDEFINED_DAY_TYPE = 'undefinedDayType';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HOLIDAY
     * @uses self::VALUE_PUBLIC_HOLIDAY
     * @uses self::VALUE_RELIGIOUS_HOLIDAY
     * @uses self::VALUE_FEDERAL_HOLIDAY
     * @uses self::VALUE_REGIONAL_HOLIDAY
     * @uses self::VALUE_NATIONAL_HOLIDAY
     * @uses self::VALUE_SUNDAYS_AND_PUBLIC_HOLIDAYS
     * @uses self::VALUE_SCHOOL_DAYS
     * @uses self::VALUE_EVERY_DAY
     * @uses self::VALUE_UNDEFINED_DAY_TYPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HOLIDAY,
            self::VALUE_PUBLIC_HOLIDAY,
            self::VALUE_RELIGIOUS_HOLIDAY,
            self::VALUE_FEDERAL_HOLIDAY,
            self::VALUE_REGIONAL_HOLIDAY,
            self::VALUE_NATIONAL_HOLIDAY,
            self::VALUE_SUNDAYS_AND_PUBLIC_HOLIDAYS,
            self::VALUE_SCHOOL_DAYS,
            self::VALUE_EVERY_DAY,
            self::VALUE_UNDEFINED_DAY_TYPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
