<?php

namespace EnumType;

/**
 * This class stands for HireFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Hire Facility.
 * @subpackage Enumerations
 */
class HireFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'carHire'
     * @return string 'carHire'
     */
    const VALUE_CAR_HIRE = 'carHire';
    /**
     * Constant for value 'motorCycleHire'
     * @return string 'motorCycleHire'
     */
    const VALUE_MOTOR_CYCLE_HIRE = 'motorCycleHire';
    /**
     * Constant for value 'cycleHire'
     * @return string 'cycleHire'
     */
    const VALUE_CYCLE_HIRE = 'cycleHire';
    /**
     * Constant for value 'taxi'
     * @return string 'taxi'
     */
    const VALUE_TAXI = 'taxi';
    /**
     * Constant for value 'recreationDeviceHire'
     * @return string 'recreationDeviceHire'
     */
    const VALUE_RECREATION_DEVICE_HIRE = 'recreationDeviceHire';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_CAR_HIRE
     * @uses self::VALUE_MOTOR_CYCLE_HIRE
     * @uses self::VALUE_CYCLE_HIRE
     * @uses self::VALUE_TAXI
     * @uses self::VALUE_RECREATION_DEVICE_HIRE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_CAR_HIRE,
            self::VALUE_MOTOR_CYCLE_HIRE,
            self::VALUE_CYCLE_HIRE,
            self::VALUE_TAXI,
            self::VALUE_RECREATION_DEVICE_HIRE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
