<?php

namespace EnumType;

/**
 * This class stands for FuelTypeEnum EnumType
 * @subpackage Enumerations
 */
class FuelTypeEnum
{
    /**
     * Constant for value 'battery'
     * @return string 'battery'
     */
    const VALUE_BATTERY = 'battery';
    /**
     * Constant for value 'biodiesel'
     * @return string 'biodiesel'
     */
    const VALUE_BIODIESEL = 'biodiesel';
    /**
     * Constant for value 'diesel'
     * @return string 'diesel'
     */
    const VALUE_DIESEL = 'diesel';
    /**
     * Constant for value 'dieselBatteryHybrid'
     * @return string 'dieselBatteryHybrid'
     */
    const VALUE_DIESEL_BATTERY_HYBRID = 'dieselBatteryHybrid';
    /**
     * Constant for value 'ethanol'
     * @return string 'ethanol'
     */
    const VALUE_ETHANOL = 'ethanol';
    /**
     * Constant for value 'hydrogen'
     * @return string 'hydrogen'
     */
    const VALUE_HYDROGEN = 'hydrogen';
    /**
     * Constant for value 'liquidGas'
     * @return string 'liquidGas'
     */
    const VALUE_LIQUID_GAS = 'liquidGas';
    /**
     * Constant for value 'lpg'
     * @return string 'lpg'
     */
    const VALUE_LPG = 'lpg';
    /**
     * Constant for value 'methane'
     * @return string 'methane'
     */
    const VALUE_METHANE = 'methane';
    /**
     * Constant for value 'petrol'
     * @return string 'petrol'
     */
    const VALUE_PETROL = 'petrol';
    /**
     * Constant for value 'petrolBatteryHybrid'
     * @return string 'petrolBatteryHybrid'
     */
    const VALUE_PETROL_BATTERY_HYBRID = 'petrolBatteryHybrid';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BATTERY
     * @uses self::VALUE_BIODIESEL
     * @uses self::VALUE_DIESEL
     * @uses self::VALUE_DIESEL_BATTERY_HYBRID
     * @uses self::VALUE_ETHANOL
     * @uses self::VALUE_HYDROGEN
     * @uses self::VALUE_LIQUID_GAS
     * @uses self::VALUE_LPG
     * @uses self::VALUE_METHANE
     * @uses self::VALUE_PETROL
     * @uses self::VALUE_PETROL_BATTERY_HYBRID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BATTERY,
            self::VALUE_BIODIESEL,
            self::VALUE_DIESEL,
            self::VALUE_DIESEL_BATTERY_HYBRID,
            self::VALUE_ETHANOL,
            self::VALUE_HYDROGEN,
            self::VALUE_LIQUID_GAS,
            self::VALUE_LPG,
            self::VALUE_METHANE,
            self::VALUE_PETROL,
            self::VALUE_PETROL_BATTERY_HYBRID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
