<?php

namespace EnumType;

/**
 * This class stands for FirstOrLastJourneyEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed types activity for FirstOrLastJourney.
 * @subpackage Enumerations
 */
class FirstOrLastJourneyEnumeration
{
    /**
     * Constant for value 'firstServiceOfDay'
     * @return string 'firstServiceOfDay'
     */
    const VALUE_FIRST_SERVICE_OF_DAY = 'firstServiceOfDay';
    /**
     * Constant for value 'otherService'
     * @return string 'otherService'
     */
    const VALUE_OTHER_SERVICE = 'otherService';
    /**
     * Constant for value 'lastServiceOfDay'
     * @return string 'lastServiceOfDay'
     */
    const VALUE_LAST_SERVICE_OF_DAY = 'lastServiceOfDay';
    /**
     * Constant for value 'unspecified'
     * @return string 'unspecified'
     */
    const VALUE_UNSPECIFIED = 'unspecified';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIRST_SERVICE_OF_DAY
     * @uses self::VALUE_OTHER_SERVICE
     * @uses self::VALUE_LAST_SERVICE_OF_DAY
     * @uses self::VALUE_UNSPECIFIED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIRST_SERVICE_OF_DAY,
            self::VALUE_OTHER_SERVICE,
            self::VALUE_LAST_SERVICE_OF_DAY,
            self::VALUE_UNSPECIFIED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
