<?php

namespace EnumType;

/**
 * This class stands for EndTimeStatusEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed values for EndTime Status.
 * @subpackage Enumerations
 */
class EndTimeStatusEnumeration
{
    /**
     * Constant for value 'undefined'
     * @return string 'undefined'
     */
    const VALUE_UNDEFINED = 'undefined';
    /**
     * Constant for value 'longTerm'
     * @return string 'longTerm'
     */
    const VALUE_LONG_TERM = 'longTerm';
    /**
     * Constant for value 'shortTerm'
     * @return string 'shortTerm'
     */
    const VALUE_SHORT_TERM = 'shortTerm';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNDEFINED
     * @uses self::VALUE_LONG_TERM
     * @uses self::VALUE_SHORT_TERM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNDEFINED,
            self::VALUE_LONG_TERM,
            self::VALUE_SHORT_TERM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
