<?php

namespace EnumType;

/**
 * This class stands for EndTimePrecisionEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed values for EndTime Precision
 * @subpackage Enumerations
 */
class EndTimePrecisionEnumeration
{
    /**
     * Constant for value 'day'
     * @return string 'day'
     */
    const VALUE_DAY = 'day';
    /**
     * Constant for value 'hour'
     * @return string 'hour'
     */
    const VALUE_HOUR = 'hour';
    /**
     * Constant for value 'second'
     * @return string 'second'
     */
    const VALUE_SECOND = 'second';
    /**
     * Constant for value 'milliSecond'
     * @return string 'milliSecond'
     */
    const VALUE_MILLI_SECOND = 'milliSecond';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DAY
     * @uses self::VALUE_HOUR
     * @uses self::VALUE_SECOND
     * @uses self::VALUE_MILLI_SECOND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DAY,
            self::VALUE_HOUR,
            self::VALUE_SECOND,
            self::VALUE_MILLI_SECOND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
