<?php

namespace EnumType;

/**
 * This class stands for DirectionCompassEnum EnumType
 * @subpackage Enumerations
 */
class DirectionCompassEnum
{
    /**
     * Constant for value 'east'
     * @return string 'east'
     */
    const VALUE_EAST = 'east';
    /**
     * Constant for value 'eastNorthEast'
     * @return string 'eastNorthEast'
     */
    const VALUE_EAST_NORTH_EAST = 'eastNorthEast';
    /**
     * Constant for value 'eastSouthEast'
     * @return string 'eastSouthEast'
     */
    const VALUE_EAST_SOUTH_EAST = 'eastSouthEast';
    /**
     * Constant for value 'north'
     * @return string 'north'
     */
    const VALUE_NORTH = 'north';
    /**
     * Constant for value 'northEast'
     * @return string 'northEast'
     */
    const VALUE_NORTH_EAST = 'northEast';
    /**
     * Constant for value 'northNorthEast'
     * @return string 'northNorthEast'
     */
    const VALUE_NORTH_NORTH_EAST = 'northNorthEast';
    /**
     * Constant for value 'northNorthWest'
     * @return string 'northNorthWest'
     */
    const VALUE_NORTH_NORTH_WEST = 'northNorthWest';
    /**
     * Constant for value 'northWest'
     * @return string 'northWest'
     */
    const VALUE_NORTH_WEST = 'northWest';
    /**
     * Constant for value 'south'
     * @return string 'south'
     */
    const VALUE_SOUTH = 'south';
    /**
     * Constant for value 'southEast'
     * @return string 'southEast'
     */
    const VALUE_SOUTH_EAST = 'southEast';
    /**
     * Constant for value 'southSouthEast'
     * @return string 'southSouthEast'
     */
    const VALUE_SOUTH_SOUTH_EAST = 'southSouthEast';
    /**
     * Constant for value 'southSouthWest'
     * @return string 'southSouthWest'
     */
    const VALUE_SOUTH_SOUTH_WEST = 'southSouthWest';
    /**
     * Constant for value 'southWest'
     * @return string 'southWest'
     */
    const VALUE_SOUTH_WEST = 'southWest';
    /**
     * Constant for value 'west'
     * @return string 'west'
     */
    const VALUE_WEST = 'west';
    /**
     * Constant for value 'westNorthWest'
     * @return string 'westNorthWest'
     */
    const VALUE_WEST_NORTH_WEST = 'westNorthWest';
    /**
     * Constant for value 'westSouthWest'
     * @return string 'westSouthWest'
     */
    const VALUE_WEST_SOUTH_WEST = 'westSouthWest';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EAST
     * @uses self::VALUE_EAST_NORTH_EAST
     * @uses self::VALUE_EAST_SOUTH_EAST
     * @uses self::VALUE_NORTH
     * @uses self::VALUE_NORTH_EAST
     * @uses self::VALUE_NORTH_NORTH_EAST
     * @uses self::VALUE_NORTH_NORTH_WEST
     * @uses self::VALUE_NORTH_WEST
     * @uses self::VALUE_SOUTH
     * @uses self::VALUE_SOUTH_EAST
     * @uses self::VALUE_SOUTH_SOUTH_EAST
     * @uses self::VALUE_SOUTH_SOUTH_WEST
     * @uses self::VALUE_SOUTH_WEST
     * @uses self::VALUE_WEST
     * @uses self::VALUE_WEST_NORTH_WEST
     * @uses self::VALUE_WEST_SOUTH_WEST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EAST,
            self::VALUE_EAST_NORTH_EAST,
            self::VALUE_EAST_SOUTH_EAST,
            self::VALUE_NORTH,
            self::VALUE_NORTH_EAST,
            self::VALUE_NORTH_NORTH_EAST,
            self::VALUE_NORTH_NORTH_WEST,
            self::VALUE_NORTH_WEST,
            self::VALUE_SOUTH,
            self::VALUE_SOUTH_EAST,
            self::VALUE_SOUTH_SOUTH_EAST,
            self::VALUE_SOUTH_SOUTH_WEST,
            self::VALUE_SOUTH_WEST,
            self::VALUE_WEST,
            self::VALUE_WEST_NORTH_WEST,
            self::VALUE_WEST_SOUTH_WEST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
