<?php

namespace EnumType;

/**
 * This class stands for DeltaModificationEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Classification of modification as addition, deletion, revision or delta only. Enumerated value.
 * @subpackage Enumerations
 */
class DeltaModificationEnumeration
{
    /**
     * Constant for value 'new'
     * @return string 'new'
     */
    const VALUE_NEW = 'new';
    /**
     * Constant for value 'delete'
     * @return string 'delete'
     */
    const VALUE_DELETE = 'delete';
    /**
     * Constant for value 'revise'
     * @return string 'revise'
     */
    const VALUE_REVISE = 'revise';
    /**
     * Constant for value 'delta'
     * @return string 'delta'
     */
    const VALUE_DELTA = 'delta';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEW
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_REVISE
     * @uses self::VALUE_DELTA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW,
            self::VALUE_DELETE,
            self::VALUE_REVISE,
            self::VALUE_DELTA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
