<?php

namespace EnumType;

/**
 * This class stands for DeliveryMethodEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Delivery Method: Fetched or Direct Delivery.
 * @subpackage Enumerations
 */
class DeliveryMethodEnumeration
{
    /**
     * Constant for value 'direct'
     * @return string 'direct'
     */
    const VALUE_DIRECT = 'direct';
    /**
     * Constant for value 'fetched'
     * @return string 'fetched'
     */
    const VALUE_FETCHED = 'fetched';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DIRECT
     * @uses self::VALUE_FETCHED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DIRECT,
            self::VALUE_FETCHED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
