<?php

namespace EnumType;

/**
 * This class stands for DelayBandEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Type for allwoed values of Dela band. Based on Datex2
 * @subpackage Enumerations
 */
class DelayBandEnumeration
{
    /**
     * Constant for value 'delayTwoMinutes'
     * @return string 'delayTwoMinutes'
     */
    const VALUE_DELAY_TWO_MINUTES = 'delayTwoMinutes';
    /**
     * Constant for value 'upToThreeMinutes'
     * @return string 'upToThreeMinutes'
     */
    const VALUE_UP_TO_THREE_MINUTES = 'upToThreeMinutes';
    /**
     * Constant for value 'upToFourMinutes'
     * @return string 'upToFourMinutes'
     */
    const VALUE_UP_TO_FOUR_MINUTES = 'upToFourMinutes';
    /**
     * Constant for value 'upToFiveMinutes'
     * @return string 'upToFiveMinutes'
     */
    const VALUE_UP_TO_FIVE_MINUTES = 'upToFiveMinutes';
    /**
     * Constant for value 'upToEightMinutes'
     * @return string 'upToEightMinutes'
     */
    const VALUE_UP_TO_EIGHT_MINUTES = 'upToEightMinutes';
    /**
     * Constant for value 'negligible'
     * @return string 'negligible'
     */
    const VALUE_NEGLIGIBLE = 'negligible';
    /**
     * Constant for value 'upToTenMinutes'
     * @return string 'upToTenMinutes'
     */
    const VALUE_UP_TO_TEN_MINUTES = 'upToTenMinutes';
    /**
     * Constant for value 'betweenTenMinutesAndThirtyMinutes'
     * @return string 'betweenTenMinutesAndThirtyMinutes'
     */
    const VALUE_BETWEEN_TEN_MINUTES_AND_THIRTY_MINUTES = 'betweenTenMinutesAndThirtyMinutes';
    /**
     * Constant for value 'betweenThirtyMinutesAndOneHour'
     * @return string 'betweenThirtyMinutesAndOneHour'
     */
    const VALUE_BETWEEN_THIRTY_MINUTES_AND_ONE_HOUR = 'betweenThirtyMinutesAndOneHour';
    /**
     * Constant for value 'betweenOneHourAndThreeHours'
     * @return string 'betweenOneHourAndThreeHours'
     */
    const VALUE_BETWEEN_ONE_HOUR_AND_THREE_HOURS = 'betweenOneHourAndThreeHours';
    /**
     * Constant for value 'betweenThreeHoursAndSixHours'
     * @return string 'betweenThreeHoursAndSixHours'
     */
    const VALUE_BETWEEN_THREE_HOURS_AND_SIX_HOURS = 'betweenThreeHoursAndSixHours';
    /**
     * Constant for value 'longerThanSixHours'
     * @return string 'longerThanSixHours'
     */
    const VALUE_LONGER_THAN_SIX_HOURS = 'longerThanSixHours';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DELAY_TWO_MINUTES
     * @uses self::VALUE_UP_TO_THREE_MINUTES
     * @uses self::VALUE_UP_TO_FOUR_MINUTES
     * @uses self::VALUE_UP_TO_FIVE_MINUTES
     * @uses self::VALUE_UP_TO_EIGHT_MINUTES
     * @uses self::VALUE_NEGLIGIBLE
     * @uses self::VALUE_UP_TO_TEN_MINUTES
     * @uses self::VALUE_BETWEEN_TEN_MINUTES_AND_THIRTY_MINUTES
     * @uses self::VALUE_BETWEEN_THIRTY_MINUTES_AND_ONE_HOUR
     * @uses self::VALUE_BETWEEN_ONE_HOUR_AND_THREE_HOURS
     * @uses self::VALUE_BETWEEN_THREE_HOURS_AND_SIX_HOURS
     * @uses self::VALUE_LONGER_THAN_SIX_HOURS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DELAY_TWO_MINUTES,
            self::VALUE_UP_TO_THREE_MINUTES,
            self::VALUE_UP_TO_FOUR_MINUTES,
            self::VALUE_UP_TO_FIVE_MINUTES,
            self::VALUE_UP_TO_EIGHT_MINUTES,
            self::VALUE_NEGLIGIBLE,
            self::VALUE_UP_TO_TEN_MINUTES,
            self::VALUE_BETWEEN_TEN_MINUTES_AND_THIRTY_MINUTES,
            self::VALUE_BETWEEN_THIRTY_MINUTES_AND_ONE_HOUR,
            self::VALUE_BETWEEN_ONE_HOUR_AND_THREE_HOURS,
            self::VALUE_BETWEEN_THREE_HOURS_AND_SIX_HOURS,
            self::VALUE_LONGER_THAN_SIX_HOURS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
