<?php

namespace EnumType;

/**
 * This class stands for DangerousGoodsRegulationsEnum EnumType
 * @subpackage Enumerations
 */
class DangerousGoodsRegulationsEnum
{
    /**
     * Constant for value 'adr'
     * @return string 'adr'
     */
    const VALUE_ADR = 'adr';
    /**
     * Constant for value 'iataIcao'
     * @return string 'iataIcao'
     */
    const VALUE_IATA_ICAO = 'iataIcao';
    /**
     * Constant for value 'imoImdg'
     * @return string 'imoImdg'
     */
    const VALUE_IMO_IMDG = 'imoImdg';
    /**
     * Constant for value 'railroadDangerousGoodsBook'
     * @return string 'railroadDangerousGoodsBook'
     */
    const VALUE_RAILROAD_DANGEROUS_GOODS_BOOK = 'railroadDangerousGoodsBook';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADR
     * @uses self::VALUE_IATA_ICAO
     * @uses self::VALUE_IMO_IMDG
     * @uses self::VALUE_RAILROAD_DANGEROUS_GOODS_BOOK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADR,
            self::VALUE_IATA_ICAO,
            self::VALUE_IMO_IMDG,
            self::VALUE_RAILROAD_DANGEROUS_GOODS_BOOK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
