<?php

namespace EnumType;

/**
 * This class stands for CountryEnum EnumType
 * @subpackage Enumerations
 */
class CountryEnum
{
    /**
     * Constant for value 'at'
     * @return string 'at'
     */
    const VALUE_AT = 'at';
    /**
     * Constant for value 'be'
     * @return string 'be'
     */
    const VALUE_BE = 'be';
    /**
     * Constant for value 'bg'
     * @return string 'bg'
     */
    const VALUE_BG = 'bg';
    /**
     * Constant for value 'ch'
     * @return string 'ch'
     */
    const VALUE_CH = 'ch';
    /**
     * Constant for value 'cs'
     * @return string 'cs'
     */
    const VALUE_CS = 'cs';
    /**
     * Constant for value 'cy'
     * @return string 'cy'
     */
    const VALUE_CY = 'cy';
    /**
     * Constant for value 'cz'
     * @return string 'cz'
     */
    const VALUE_CZ = 'cz';
    /**
     * Constant for value 'de'
     * @return string 'de'
     */
    const VALUE_DE = 'de';
    /**
     * Constant for value 'dk'
     * @return string 'dk'
     */
    const VALUE_DK = 'dk';
    /**
     * Constant for value 'ee'
     * @return string 'ee'
     */
    const VALUE_EE = 'ee';
    /**
     * Constant for value 'es'
     * @return string 'es'
     */
    const VALUE_ES = 'es';
    /**
     * Constant for value 'fi'
     * @return string 'fi'
     */
    const VALUE_FI = 'fi';
    /**
     * Constant for value 'fo'
     * @return string 'fo'
     */
    const VALUE_FO = 'fo';
    /**
     * Constant for value 'fr'
     * @return string 'fr'
     */
    const VALUE_FR = 'fr';
    /**
     * Constant for value 'gb'
     * @return string 'gb'
     */
    const VALUE_GB = 'gb';
    /**
     * Constant for value 'gg'
     * @return string 'gg'
     */
    const VALUE_GG = 'gg';
    /**
     * Constant for value 'gi'
     * @return string 'gi'
     */
    const VALUE_GI = 'gi';
    /**
     * Constant for value 'gr'
     * @return string 'gr'
     */
    const VALUE_GR = 'gr';
    /**
     * Constant for value 'hr'
     * @return string 'hr'
     */
    const VALUE_HR = 'hr';
    /**
     * Constant for value 'hu'
     * @return string 'hu'
     */
    const VALUE_HU = 'hu';
    /**
     * Constant for value 'ie'
     * @return string 'ie'
     */
    const VALUE_IE = 'ie';
    /**
     * Constant for value 'im'
     * @return string 'im'
     */
    const VALUE_IM = 'im';
    /**
     * Constant for value 'is'
     * @return string 'is'
     */
    const VALUE_IS = 'is';
    /**
     * Constant for value 'it'
     * @return string 'it'
     */
    const VALUE_IT = 'it';
    /**
     * Constant for value 'je'
     * @return string 'je'
     */
    const VALUE_JE = 'je';
    /**
     * Constant for value 'li'
     * @return string 'li'
     */
    const VALUE_LI = 'li';
    /**
     * Constant for value 'lt'
     * @return string 'lt'
     */
    const VALUE_LT = 'lt';
    /**
     * Constant for value 'lu'
     * @return string 'lu'
     */
    const VALUE_LU = 'lu';
    /**
     * Constant for value 'lv'
     * @return string 'lv'
     */
    const VALUE_LV = 'lv';
    /**
     * Constant for value 'ma'
     * @return string 'ma'
     */
    const VALUE_MA = 'ma';
    /**
     * Constant for value 'mc'
     * @return string 'mc'
     */
    const VALUE_MC = 'mc';
    /**
     * Constant for value 'mk'
     * @return string 'mk'
     */
    const VALUE_MK = 'mk';
    /**
     * Constant for value 'mt'
     * @return string 'mt'
     */
    const VALUE_MT = 'mt';
    /**
     * Constant for value 'nl'
     * @return string 'nl'
     */
    const VALUE_NL = 'nl';
    /**
     * Constant for value 'no'
     * @return string 'no'
     */
    const VALUE_NO = 'no';
    /**
     * Constant for value 'pl'
     * @return string 'pl'
     */
    const VALUE_PL = 'pl';
    /**
     * Constant for value 'pt'
     * @return string 'pt'
     */
    const VALUE_PT = 'pt';
    /**
     * Constant for value 'ro'
     * @return string 'ro'
     */
    const VALUE_RO = 'ro';
    /**
     * Constant for value 'se'
     * @return string 'se'
     */
    const VALUE_SE = 'se';
    /**
     * Constant for value 'si'
     * @return string 'si'
     */
    const VALUE_SI = 'si';
    /**
     * Constant for value 'sk'
     * @return string 'sk'
     */
    const VALUE_SK = 'sk';
    /**
     * Constant for value 'sm'
     * @return string 'sm'
     */
    const VALUE_SM = 'sm';
    /**
     * Constant for value 'tr'
     * @return string 'tr'
     */
    const VALUE_TR = 'tr';
    /**
     * Constant for value 'va'
     * @return string 'va'
     */
    const VALUE_VA = 'va';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AT
     * @uses self::VALUE_BE
     * @uses self::VALUE_BG
     * @uses self::VALUE_CH
     * @uses self::VALUE_CS
     * @uses self::VALUE_CY
     * @uses self::VALUE_CZ
     * @uses self::VALUE_DE
     * @uses self::VALUE_DK
     * @uses self::VALUE_EE
     * @uses self::VALUE_ES
     * @uses self::VALUE_FI
     * @uses self::VALUE_FO
     * @uses self::VALUE_FR
     * @uses self::VALUE_GB
     * @uses self::VALUE_GG
     * @uses self::VALUE_GI
     * @uses self::VALUE_GR
     * @uses self::VALUE_HR
     * @uses self::VALUE_HU
     * @uses self::VALUE_IE
     * @uses self::VALUE_IM
     * @uses self::VALUE_IS
     * @uses self::VALUE_IT
     * @uses self::VALUE_JE
     * @uses self::VALUE_LI
     * @uses self::VALUE_LT
     * @uses self::VALUE_LU
     * @uses self::VALUE_LV
     * @uses self::VALUE_MA
     * @uses self::VALUE_MC
     * @uses self::VALUE_MK
     * @uses self::VALUE_MT
     * @uses self::VALUE_NL
     * @uses self::VALUE_NO
     * @uses self::VALUE_PL
     * @uses self::VALUE_PT
     * @uses self::VALUE_RO
     * @uses self::VALUE_SE
     * @uses self::VALUE_SI
     * @uses self::VALUE_SK
     * @uses self::VALUE_SM
     * @uses self::VALUE_TR
     * @uses self::VALUE_VA
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AT,
            self::VALUE_BE,
            self::VALUE_BG,
            self::VALUE_CH,
            self::VALUE_CS,
            self::VALUE_CY,
            self::VALUE_CZ,
            self::VALUE_DE,
            self::VALUE_DK,
            self::VALUE_EE,
            self::VALUE_ES,
            self::VALUE_FI,
            self::VALUE_FO,
            self::VALUE_FR,
            self::VALUE_GB,
            self::VALUE_GG,
            self::VALUE_GI,
            self::VALUE_GR,
            self::VALUE_HR,
            self::VALUE_HU,
            self::VALUE_IE,
            self::VALUE_IM,
            self::VALUE_IS,
            self::VALUE_IT,
            self::VALUE_JE,
            self::VALUE_LI,
            self::VALUE_LT,
            self::VALUE_LU,
            self::VALUE_LV,
            self::VALUE_MA,
            self::VALUE_MC,
            self::VALUE_MK,
            self::VALUE_MT,
            self::VALUE_NL,
            self::VALUE_NO,
            self::VALUE_PL,
            self::VALUE_PT,
            self::VALUE_RO,
            self::VALUE_SE,
            self::VALUE_SI,
            self::VALUE_SK,
            self::VALUE_SM,
            self::VALUE_TR,
            self::VALUE_VA,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
