<?php

namespace EnumType;

/**
 * This class stands for ContinuousModesEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: MODEs of transport applicable to private and non-timetabled transport.
 * @subpackage Enumerations
 */
class ContinuousModesEnumeration
{
    /**
     * Constant for value 'walk'
     * @return string 'walk'
     */
    const VALUE_WALK = 'walk';
    /**
     * Constant for value 'car'
     * @return string 'car'
     */
    const VALUE_CAR = 'car';
    /**
     * Constant for value 'taxi'
     * @return string 'taxi'
     */
    const VALUE_TAXI = 'taxi';
    /**
     * Constant for value 'cycle'
     * @return string 'cycle'
     */
    const VALUE_CYCLE = 'cycle';
    /**
     * Constant for value 'drt'
     * @return string 'drt'
     */
    const VALUE_DRT = 'drt';
    /**
     * Constant for value 'movingWalkway'
     * @return string 'movingWalkway'
     */
    const VALUE_MOVING_WALKWAY = 'movingWalkway';
    /**
     * Constant for value 'through'
     * @return string 'through'
     */
    const VALUE_THROUGH = 'through';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WALK
     * @uses self::VALUE_CAR
     * @uses self::VALUE_TAXI
     * @uses self::VALUE_CYCLE
     * @uses self::VALUE_DRT
     * @uses self::VALUE_MOVING_WALKWAY
     * @uses self::VALUE_THROUGH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WALK,
            self::VALUE_CAR,
            self::VALUE_TAXI,
            self::VALUE_CYCLE,
            self::VALUE_DRT,
            self::VALUE_MOVING_WALKWAY,
            self::VALUE_THROUGH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
