<?php

namespace EnumType;

/**
 * This class stands for ConfidentialityValueEnum EnumType
 * @subpackage Enumerations
 */
class ConfidentialityValueEnum
{
    /**
     * Constant for value 'internalUse'
     * @return string 'internalUse'
     */
    const VALUE_INTERNAL_USE = 'internalUse';
    /**
     * Constant for value 'noRestriction'
     * @return string 'noRestriction'
     */
    const VALUE_NO_RESTRICTION = 'noRestriction';
    /**
     * Constant for value 'restrictedToAuthorities'
     * @return string 'restrictedToAuthorities'
     */
    const VALUE_RESTRICTED_TO_AUTHORITIES = 'restrictedToAuthorities';
    /**
     * Constant for value 'restrictedToAuthoritiesAndTrafficOperators'
     * @return string 'restrictedToAuthoritiesAndTrafficOperators'
     */
    const VALUE_RESTRICTED_TO_AUTHORITIES_AND_TRAFFIC_OPERATORS = 'restrictedToAuthoritiesAndTrafficOperators';
    /**
     * Constant for value 'restrictedToAuthoritiesTrafficOperatorsAndPublishers'
     * @return string 'restrictedToAuthoritiesTrafficOperatorsAndPublishers'
     */
    const VALUE_RESTRICTED_TO_AUTHORITIES_TRAFFIC_OPERATORS_AND_PUBLISHERS = 'restrictedToAuthoritiesTrafficOperatorsAndPublishers';
    /**
     * Constant for value 'restrictedToAuthoritiesTrafficOperatorsAndVms'
     * @return string 'restrictedToAuthoritiesTrafficOperatorsAndVms'
     */
    const VALUE_RESTRICTED_TO_AUTHORITIES_TRAFFIC_OPERATORS_AND_VMS = 'restrictedToAuthoritiesTrafficOperatorsAndVms';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INTERNAL_USE
     * @uses self::VALUE_NO_RESTRICTION
     * @uses self::VALUE_RESTRICTED_TO_AUTHORITIES
     * @uses self::VALUE_RESTRICTED_TO_AUTHORITIES_AND_TRAFFIC_OPERATORS
     * @uses self::VALUE_RESTRICTED_TO_AUTHORITIES_TRAFFIC_OPERATORS_AND_PUBLISHERS
     * @uses self::VALUE_RESTRICTED_TO_AUTHORITIES_TRAFFIC_OPERATORS_AND_VMS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INTERNAL_USE,
            self::VALUE_NO_RESTRICTION,
            self::VALUE_RESTRICTED_TO_AUTHORITIES,
            self::VALUE_RESTRICTED_TO_AUTHORITIES_AND_TRAFFIC_OPERATORS,
            self::VALUE_RESTRICTED_TO_AUTHORITIES_TRAFFIC_OPERATORS_AND_PUBLISHERS,
            self::VALUE_RESTRICTED_TO_AUTHORITIES_TRAFFIC_OPERATORS_AND_VMS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
