<?php

namespace EnumType;

/**
 * This class stands for ComplianceOptionEnum EnumType
 * @subpackage Enumerations
 */
class ComplianceOptionEnum
{
    /**
     * Constant for value 'advisory'
     * @return string 'advisory'
     */
    const VALUE_ADVISORY = 'advisory';
    /**
     * Constant for value 'mandatory'
     * @return string 'mandatory'
     */
    const VALUE_MANDATORY = 'mandatory';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADVISORY
     * @uses self::VALUE_MANDATORY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADVISORY,
            self::VALUE_MANDATORY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
