<?php

namespace EnumType;

/**
 * This class stands for CompassBearing16Enumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: 16 point compass.
 * @subpackage Enumerations
 */
class CompassBearing16Enumeration
{
    /**
     * Constant for value ''
     * @return string ''
     */
    const VALUE_ = '';
    /**
     * Constant for value 'SW'
     * @return string 'SW'
     */
    const VALUE_SW = 'SW';
    /**
     * Constant for value 'SE'
     * @return string 'SE'
     */
    const VALUE_SE = 'SE';
    /**
     * Constant for value 'NW'
     * @return string 'NW'
     */
    const VALUE_NW = 'NW';
    /**
     * Constant for value 'NE'
     * @return string 'NE'
     */
    const VALUE_NE = 'NE';
    /**
     * Constant for value 'W'
     * @return string 'W'
     */
    const VALUE_W = 'W';
    /**
     * Constant for value 'E'
     * @return string 'E'
     */
    const VALUE_E = 'E';
    /**
     * Constant for value 'S'
     * @return string 'S'
     */
    const VALUE_S = 'S';
    /**
     * Constant for value 'N'
     * @return string 'N'
     */
    const VALUE_N = 'N';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_
     * @uses self::VALUE_SW
     * @uses self::VALUE_SE
     * @uses self::VALUE_NW
     * @uses self::VALUE_NE
     * @uses self::VALUE_W
     * @uses self::VALUE_E
     * @uses self::VALUE_S
     * @uses self::VALUE_N
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_,
            self::VALUE_SW,
            self::VALUE_SE,
            self::VALUE_NW,
            self::VALUE_NE,
            self::VALUE_W,
            self::VALUE_E,
            self::VALUE_S,
            self::VALUE_N,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
