<?php

namespace EnumType;

/**
 * This class stands for CarriagewayEnum EnumType
 * @subpackage Enumerations
 */
class CarriagewayEnum
{
    /**
     * Constant for value 'connectingCarriageway'
     * @return string 'connectingCarriageway'
     */
    const VALUE_CONNECTING_CARRIAGEWAY = 'connectingCarriageway';
    /**
     * Constant for value 'entrySlipRoad'
     * @return string 'entrySlipRoad'
     */
    const VALUE_ENTRY_SLIP_ROAD = 'entrySlipRoad';
    /**
     * Constant for value 'exitSlipRoad'
     * @return string 'exitSlipRoad'
     */
    const VALUE_EXIT_SLIP_ROAD = 'exitSlipRoad';
    /**
     * Constant for value 'flyover'
     * @return string 'flyover'
     */
    const VALUE_FLYOVER = 'flyover';
    /**
     * Constant for value 'leftHandFeederRoad'
     * @return string 'leftHandFeederRoad'
     */
    const VALUE_LEFT_HAND_FEEDER_ROAD = 'leftHandFeederRoad';
    /**
     * Constant for value 'leftHandParallelCarriageway'
     * @return string 'leftHandParallelCarriageway'
     */
    const VALUE_LEFT_HAND_PARALLEL_CARRIAGEWAY = 'leftHandParallelCarriageway';
    /**
     * Constant for value 'mainCarriageway'
     * @return string 'mainCarriageway'
     */
    const VALUE_MAIN_CARRIAGEWAY = 'mainCarriageway';
    /**
     * Constant for value 'oppositeCarriageway'
     * @return string 'oppositeCarriageway'
     */
    const VALUE_OPPOSITE_CARRIAGEWAY = 'oppositeCarriageway';
    /**
     * Constant for value 'parallelCarriageway'
     * @return string 'parallelCarriageway'
     */
    const VALUE_PARALLEL_CARRIAGEWAY = 'parallelCarriageway';
    /**
     * Constant for value 'rightHandFeederRoad'
     * @return string 'rightHandFeederRoad'
     */
    const VALUE_RIGHT_HAND_FEEDER_ROAD = 'rightHandFeederRoad';
    /**
     * Constant for value 'rightHandParallelCarriageway'
     * @return string 'rightHandParallelCarriageway'
     */
    const VALUE_RIGHT_HAND_PARALLEL_CARRIAGEWAY = 'rightHandParallelCarriageway';
    /**
     * Constant for value 'serviceRoad'
     * @return string 'serviceRoad'
     */
    const VALUE_SERVICE_ROAD = 'serviceRoad';
    /**
     * Constant for value 'slipRoads'
     * @return string 'slipRoads'
     */
    const VALUE_SLIP_ROADS = 'slipRoads';
    /**
     * Constant for value 'underpass'
     * @return string 'underpass'
     */
    const VALUE_UNDERPASS = 'underpass';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONNECTING_CARRIAGEWAY
     * @uses self::VALUE_ENTRY_SLIP_ROAD
     * @uses self::VALUE_EXIT_SLIP_ROAD
     * @uses self::VALUE_FLYOVER
     * @uses self::VALUE_LEFT_HAND_FEEDER_ROAD
     * @uses self::VALUE_LEFT_HAND_PARALLEL_CARRIAGEWAY
     * @uses self::VALUE_MAIN_CARRIAGEWAY
     * @uses self::VALUE_OPPOSITE_CARRIAGEWAY
     * @uses self::VALUE_PARALLEL_CARRIAGEWAY
     * @uses self::VALUE_RIGHT_HAND_FEEDER_ROAD
     * @uses self::VALUE_RIGHT_HAND_PARALLEL_CARRIAGEWAY
     * @uses self::VALUE_SERVICE_ROAD
     * @uses self::VALUE_SLIP_ROADS
     * @uses self::VALUE_UNDERPASS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONNECTING_CARRIAGEWAY,
            self::VALUE_ENTRY_SLIP_ROAD,
            self::VALUE_EXIT_SLIP_ROAD,
            self::VALUE_FLYOVER,
            self::VALUE_LEFT_HAND_FEEDER_ROAD,
            self::VALUE_LEFT_HAND_PARALLEL_CARRIAGEWAY,
            self::VALUE_MAIN_CARRIAGEWAY,
            self::VALUE_OPPOSITE_CARRIAGEWAY,
            self::VALUE_PARALLEL_CARRIAGEWAY,
            self::VALUE_RIGHT_HAND_FEEDER_ROAD,
            self::VALUE_RIGHT_HAND_PARALLEL_CARRIAGEWAY,
            self::VALUE_SERVICE_ROAD,
            self::VALUE_SLIP_ROADS,
            self::VALUE_UNDERPASS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
