<?php

namespace EnumType;

/**
 * This class stands for CarParkConfigurationEnum EnumType
 * @subpackage Enumerations
 */
class CarParkConfigurationEnum
{
    /**
     * Constant for value 'multiStorey'
     * @return string 'multiStorey'
     */
    const VALUE_MULTI_STOREY = 'multiStorey';
    /**
     * Constant for value 'parkAndRide'
     * @return string 'parkAndRide'
     */
    const VALUE_PARK_AND_RIDE = 'parkAndRide';
    /**
     * Constant for value 'singleLevel'
     * @return string 'singleLevel'
     */
    const VALUE_SINGLE_LEVEL = 'singleLevel';
    /**
     * Constant for value 'underground'
     * @return string 'underground'
     */
    const VALUE_UNDERGROUND = 'underground';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MULTI_STOREY
     * @uses self::VALUE_PARK_AND_RIDE
     * @uses self::VALUE_SINGLE_LEVEL
     * @uses self::VALUE_UNDERGROUND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MULTI_STOREY,
            self::VALUE_PARK_AND_RIDE,
            self::VALUE_SINGLE_LEVEL,
            self::VALUE_UNDERGROUND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
