<?php

namespace EnumType;

/**
 * This class stands for BoardingPositionTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of BOARDING POSITION Types.
 * @subpackage Enumerations
 */
class BoardingPositionTypeEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'doorFromAirlineGate'
     * @return string 'doorFromAirlineGate'
     */
    const VALUE_DOOR_FROM_AIRLINE_GATE = 'doorFromAirlineGate';
    /**
     * Constant for value 'positionOnRailPlatform'
     * @return string 'positionOnRailPlatform'
     */
    const VALUE_POSITION_ON_RAIL_PLATFORM = 'positionOnRailPlatform';
    /**
     * Constant for value 'positionOnMetroPlatform'
     * @return string 'positionOnMetroPlatform'
     */
    const VALUE_POSITION_ON_METRO_PLATFORM = 'positionOnMetroPlatform';
    /**
     * Constant for value 'positionAtCoachStop'
     * @return string 'positionAtCoachStop'
     */
    const VALUE_POSITION_AT_COACH_STOP = 'positionAtCoachStop';
    /**
     * Constant for value 'positionAtBusStop'
     * @return string 'positionAtBusStop'
     */
    const VALUE_POSITION_AT_BUS_STOP = 'positionAtBusStop';
    /**
     * Constant for value 'boatGangway'
     * @return string 'boatGangway'
     */
    const VALUE_BOAT_GANGWAY = 'boatGangway';
    /**
     * Constant for value 'ferryGangway'
     * @return string 'ferryGangway'
     */
    const VALUE_FERRY_GANGWAY = 'ferryGangway';
    /**
     * Constant for value 'telecabinePlatfrom'
     * @return string 'telecabinePlatfrom'
     */
    const VALUE_TELECABINE_PLATFROM = 'telecabinePlatfrom';
    /**
     * Constant for value 'setDownPoint'
     * @return string 'setDownPoint'
     */
    const VALUE_SET_DOWN_POINT = 'setDownPoint';
    /**
     * Constant for value 'taxiBay'
     * @return string 'taxiBay'
     */
    const VALUE_TAXI_BAY = 'taxiBay';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_DOOR_FROM_AIRLINE_GATE
     * @uses self::VALUE_POSITION_ON_RAIL_PLATFORM
     * @uses self::VALUE_POSITION_ON_METRO_PLATFORM
     * @uses self::VALUE_POSITION_AT_COACH_STOP
     * @uses self::VALUE_POSITION_AT_BUS_STOP
     * @uses self::VALUE_BOAT_GANGWAY
     * @uses self::VALUE_FERRY_GANGWAY
     * @uses self::VALUE_TELECABINE_PLATFROM
     * @uses self::VALUE_SET_DOWN_POINT
     * @uses self::VALUE_TAXI_BAY
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_DOOR_FROM_AIRLINE_GATE,
            self::VALUE_POSITION_ON_RAIL_PLATFORM,
            self::VALUE_POSITION_ON_METRO_PLATFORM,
            self::VALUE_POSITION_AT_COACH_STOP,
            self::VALUE_POSITION_AT_BUS_STOP,
            self::VALUE_BOAT_GANGWAY,
            self::VALUE_FERRY_GANGWAY,
            self::VALUE_TELECABINE_PLATFROM,
            self::VALUE_SET_DOWN_POINT,
            self::VALUE_TAXI_BAY,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
