<?php

namespace EnumType;

/**
 * This class stands for AuthorityOperationTypeEnum EnumType
 * @subpackage Enumerations
 */
class AuthorityOperationTypeEnum
{
    /**
     * Constant for value 'accidentInvestigationWork'
     * @return string 'accidentInvestigationWork'
     */
    const VALUE_ACCIDENT_INVESTIGATION_WORK = 'accidentInvestigationWork';
    /**
     * Constant for value 'bombSquadInAction'
     * @return string 'bombSquadInAction'
     */
    const VALUE_BOMB_SQUAD_IN_ACTION = 'bombSquadInAction';
    /**
     * Constant for value 'civilEmergency'
     * @return string 'civilEmergency'
     */
    const VALUE_CIVIL_EMERGENCY = 'civilEmergency';
    /**
     * Constant for value 'customsOperation'
     * @return string 'customsOperation'
     */
    const VALUE_CUSTOMS_OPERATION = 'customsOperation';
    /**
     * Constant for value 'juridicalReconstruction'
     * @return string 'juridicalReconstruction'
     */
    const VALUE_JURIDICAL_RECONSTRUCTION = 'juridicalReconstruction';
    /**
     * Constant for value 'policeCheckPoint'
     * @return string 'policeCheckPoint'
     */
    const VALUE_POLICE_CHECK_POINT = 'policeCheckPoint';
    /**
     * Constant for value 'policeInvestigation'
     * @return string 'policeInvestigation'
     */
    const VALUE_POLICE_INVESTIGATION = 'policeInvestigation';
    /**
     * Constant for value 'roadOperatorCheckPoint'
     * @return string 'roadOperatorCheckPoint'
     */
    const VALUE_ROAD_OPERATOR_CHECK_POINT = 'roadOperatorCheckPoint';
    /**
     * Constant for value 'survey'
     * @return string 'survey'
     */
    const VALUE_SURVEY = 'survey';
    /**
     * Constant for value 'transportOfVip'
     * @return string 'transportOfVip'
     */
    const VALUE_TRANSPORT_OF_VIP = 'transportOfVip';
    /**
     * Constant for value 'undefinedAuthorityActivity'
     * @return string 'undefinedAuthorityActivity'
     */
    const VALUE_UNDEFINED_AUTHORITY_ACTIVITY = 'undefinedAuthorityActivity';
    /**
     * Constant for value 'vehicleInspectionCheckPoint'
     * @return string 'vehicleInspectionCheckPoint'
     */
    const VALUE_VEHICLE_INSPECTION_CHECK_POINT = 'vehicleInspectionCheckPoint';
    /**
     * Constant for value 'vehicleWeighing'
     * @return string 'vehicleWeighing'
     */
    const VALUE_VEHICLE_WEIGHING = 'vehicleWeighing';
    /**
     * Constant for value 'weighInMotion'
     * @return string 'weighInMotion'
     */
    const VALUE_WEIGH_IN_MOTION = 'weighInMotion';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCIDENT_INVESTIGATION_WORK
     * @uses self::VALUE_BOMB_SQUAD_IN_ACTION
     * @uses self::VALUE_CIVIL_EMERGENCY
     * @uses self::VALUE_CUSTOMS_OPERATION
     * @uses self::VALUE_JURIDICAL_RECONSTRUCTION
     * @uses self::VALUE_POLICE_CHECK_POINT
     * @uses self::VALUE_POLICE_INVESTIGATION
     * @uses self::VALUE_ROAD_OPERATOR_CHECK_POINT
     * @uses self::VALUE_SURVEY
     * @uses self::VALUE_TRANSPORT_OF_VIP
     * @uses self::VALUE_UNDEFINED_AUTHORITY_ACTIVITY
     * @uses self::VALUE_VEHICLE_INSPECTION_CHECK_POINT
     * @uses self::VALUE_VEHICLE_WEIGHING
     * @uses self::VALUE_WEIGH_IN_MOTION
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCIDENT_INVESTIGATION_WORK,
            self::VALUE_BOMB_SQUAD_IN_ACTION,
            self::VALUE_CIVIL_EMERGENCY,
            self::VALUE_CUSTOMS_OPERATION,
            self::VALUE_JURIDICAL_RECONSTRUCTION,
            self::VALUE_POLICE_CHECK_POINT,
            self::VALUE_POLICE_INVESTIGATION,
            self::VALUE_ROAD_OPERATOR_CHECK_POINT,
            self::VALUE_SURVEY,
            self::VALUE_TRANSPORT_OF_VIP,
            self::VALUE_UNDEFINED_AUTHORITY_ACTIVITY,
            self::VALUE_VEHICLE_INSPECTION_CHECK_POINT,
            self::VALUE_VEHICLE_WEIGHING,
            self::VALUE_WEIGH_IN_MOTION,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
