<?php

namespace EnumType;

/**
 * This class stands for AnimalPresenceTypeEnum EnumType
 * @subpackage Enumerations
 */
class AnimalPresenceTypeEnum
{
    /**
     * Constant for value 'animalsOnTheRoad'
     * @return string 'animalsOnTheRoad'
     */
    const VALUE_ANIMALS_ON_THE_ROAD = 'animalsOnTheRoad';
    /**
     * Constant for value 'herdOfAnimalsOnTheRoad'
     * @return string 'herdOfAnimalsOnTheRoad'
     */
    const VALUE_HERD_OF_ANIMALS_ON_THE_ROAD = 'herdOfAnimalsOnTheRoad';
    /**
     * Constant for value 'largeAnimalsOnTheRoad'
     * @return string 'largeAnimalsOnTheRoad'
     */
    const VALUE_LARGE_ANIMALS_ON_THE_ROAD = 'largeAnimalsOnTheRoad';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ANIMALS_ON_THE_ROAD
     * @uses self::VALUE_HERD_OF_ANIMALS_ON_THE_ROAD
     * @uses self::VALUE_LARGE_ANIMALS_ON_THE_ROAD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ANIMALS_ON_THE_ROAD,
            self::VALUE_HERD_OF_ANIMALS_ON_THE_ROAD,
            self::VALUE_LARGE_ANIMALS_ON_THE_ROAD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
