<?php

namespace EnumType;

/**
 * This class stands for AccessibilityFeatureEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed values for a CHECK CONSTRAINT.
 * @subpackage Enumerations
 */
class AccessibilityFeatureEnumeration
{
    /**
     * Constant for value 'lift'
     * @return string 'lift'
     */
    const VALUE_LIFT = 'lift';
    /**
     * Constant for value 'stairs'
     * @return string 'stairs'
     */
    const VALUE_STAIRS = 'stairs';
    /**
     * Constant for value 'seriesOfStairs'
     * @return string 'seriesOfStairs'
     */
    const VALUE_SERIES_OF_STAIRS = 'seriesOfStairs';
    /**
     * Constant for value 'escalator'
     * @return string 'escalator'
     */
    const VALUE_ESCALATOR = 'escalator';
    /**
     * Constant for value 'travelator'
     * @return string 'travelator'
     */
    const VALUE_TRAVELATOR = 'travelator';
    /**
     * Constant for value 'ramp'
     * @return string 'ramp'
     */
    const VALUE_RAMP = 'ramp';
    /**
     * Constant for value 'shuttle'
     * @return string 'shuttle'
     */
    const VALUE_SHUTTLE = 'shuttle';
    /**
     * Constant for value 'barrier'
     * @return string 'barrier'
     */
    const VALUE_BARRIER = 'barrier';
    /**
     * Constant for value 'narrowEntrance'
     * @return string 'narrowEntrance'
     */
    const VALUE_NARROW_ENTRANCE = 'narrowEntrance';
    /**
     * Constant for value 'confinedSpace'
     * @return string 'confinedSpace'
     */
    const VALUE_CONFINED_SPACE = 'confinedSpace';
    /**
     * Constant for value 'queueManagement'
     * @return string 'queueManagement'
     */
    const VALUE_QUEUE_MANAGEMENT = 'queueManagement';
    /**
     * Constant for value 'none'
     * @return string 'none'
     */
    const VALUE_NONE = 'none';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LIFT
     * @uses self::VALUE_STAIRS
     * @uses self::VALUE_SERIES_OF_STAIRS
     * @uses self::VALUE_ESCALATOR
     * @uses self::VALUE_TRAVELATOR
     * @uses self::VALUE_RAMP
     * @uses self::VALUE_SHUTTLE
     * @uses self::VALUE_BARRIER
     * @uses self::VALUE_NARROW_ENTRANCE
     * @uses self::VALUE_CONFINED_SPACE
     * @uses self::VALUE_QUEUE_MANAGEMENT
     * @uses self::VALUE_NONE
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LIFT,
            self::VALUE_STAIRS,
            self::VALUE_SERIES_OF_STAIRS,
            self::VALUE_ESCALATOR,
            self::VALUE_TRAVELATOR,
            self::VALUE_RAMP,
            self::VALUE_SHUTTLE,
            self::VALUE_BARRIER,
            self::VALUE_NARROW_ENTRANCE,
            self::VALUE_CONFINED_SPACE,
            self::VALUE_QUEUE_MANAGEMENT,
            self::VALUE_NONE,
            self::VALUE_UNKNOWN,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
