<?php

namespace EnumType;

/**
 * This class stands for AccessibilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of values for an accessibility value.
 * @subpackage Enumerations
 */
class AccessibilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'false'
     * @return string 'false'
     */
    const VALUE_FALSE = 'false';
    /**
     * Constant for value 'true'
     * @return string 'true'
     */
    const VALUE_TRUE = 'true';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_FALSE
     * @uses self::VALUE_TRUE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_FALSE,
            self::VALUE_TRUE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
