<?php

namespace EnumType;

/**
 * This class stands for AccessModesEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed categroies of access to stop place.
 * @subpackage Enumerations
 */
class AccessModesEnumeration
{
    /**
     * Constant for value 'foot'
     * @return string 'foot'
     */
    const VALUE_FOOT = 'foot';
    /**
     * Constant for value 'bicycle'
     * @return string 'bicycle'
     */
    const VALUE_BICYCLE = 'bicycle';
    /**
     * Constant for value 'car'
     * @return string 'car'
     */
    const VALUE_CAR = 'car';
    /**
     * Constant for value 'taxi'
     * @return string 'taxi'
     */
    const VALUE_TAXI = 'taxi';
    /**
     * Constant for value 'shuttle'
     * @return string 'shuttle'
     */
    const VALUE_SHUTTLE = 'shuttle';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FOOT
     * @uses self::VALUE_BICYCLE
     * @uses self::VALUE_CAR
     * @uses self::VALUE_TAXI
     * @uses self::VALUE_SHUTTLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FOOT,
            self::VALUE_BICYCLE,
            self::VALUE_CAR,
            self::VALUE_TAXI,
            self::VALUE_SHUTTLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
